/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlDirectiveType;
import com.intellij.velocity.psi.VtlElementTypes;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlBlock
extends TemplateLanguageBlock {
    protected VtlBlock(@NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings codeStyleSettings, @NotNull ASTNode node, @Nullable List<DataLanguageBlockWrapper> foreignChildren, @Nullable Wrap wrap) {
        if (blockFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockFactory", "com/intellij/velocity/psi/formatter/VtlBlock", "<init>"));
        }
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/intellij/velocity/psi/formatter/VtlBlock", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/psi/formatter/VtlBlock", "<init>"));
        }
        super(node, wrap, null, blockFactory, codeStyleSettings, foreignChildren);
    }

    protected Wrap createChildWrap(ASTNode child) {
        if (VtlBlock.isStringLiteral(child)) {
            return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
        }
        return super.createChildWrap(child);
    }

    private static boolean isStringLiteral(ASTNode child) {
        return VtlCompositeElementTypes.STRING_LITERALS.contains(child.getElementType());
    }

    public Indent getIndent() {
        if (this.getParent() == null || this.getParent().getParent() == null) {
            return Indent.getNoneIndent();
        }
        IElementType type = this.getNode().getElementType();
        if (type instanceof VtlDirectiveType && type != VtlCompositeElementTypes.DIRECTIVE_ELSEIF && type != VtlCompositeElementTypes.DIRECTIVE_ELSE || VtlBlock.isStringLiteral(this.getNode()) || type == VtlCompositeElementTypes.DIRECTIVE_BREAK || type == VtlCompositeElementTypes.INTERPOLATION) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    protected Indent getChildIndent() {
        return this.getNode().getTreeParent() == null ? Indent.getNoneIndent() : Indent.getNormalIndent();
    }

    protected IElementType getTemplateTextElementType() {
        return VtlElementTypes.TEMPLATE_TEXT;
    }

    public Wrap substituteTemplateChildWrap(@NotNull DataLanguageBlockWrapper child, @Nullable Wrap childWrap) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/velocity/psi/formatter/VtlBlock", "substituteTemplateChildWrap"));
        }
        if (VtlBlock.isStringLiteral(this.getNode())) {
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
        }
        return childWrap;
    }

    @Nullable
    public Spacing getRightNeighborSpacing(@NotNull Block rightNeighbor, @NotNull DataLanguageBlockWrapper parent, int thisBlockIndex) {
        int i;
        if (rightNeighbor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightNeighbor", "com/intellij/velocity/psi/formatter/VtlBlock", "getRightNeighborSpacing"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/velocity/psi/formatter/VtlBlock", "getRightNeighborSpacing"));
        }
        List siblings = parent.getSubBlocks();
        for (i = thisBlockIndex - 1; i >= 0 && !(siblings.get(i) instanceof DataLanguageBlockWrapper); --i) {
        }
        return parent.getSpacing(i < 0 ? null : (Block)siblings.get(i), rightNeighbor);
    }
}

