/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramFileType;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusListener;
import com.intellij.util.messages.Topic;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramProvider<T> {
    public static final ExtensionPointName<DiagramProvider> DIAGRAM_PROVIDER = new ExtensionPointName("com.intellij.diagram.Provider");
    private static final DiagramColorManager defaultColorManager = new DiagramColorManagerBase();
    public static final Key<Object> ORIGINAL_ELEMENT = Key.create((String)"diagram.original.element");
    private static final AtomicNotNullLazyValue<Set<String>> ourPlaces = AtomicNotNullLazyValue.createValue(() -> JBIterable.of((Object[])DIAGRAM_PROVIDER.getExtensions()).flatMap(o -> o.getActionPlaces()).toSet());

    @Pattern(value="[a-zA-Z0-9_-]*")
    public abstract String getID();

    public abstract DiagramVisibilityManager createVisibilityManager();

    public abstract DiagramNodeContentManager getNodeContentManager();

    public abstract DiagramElementManager<T> getElementManager();

    public abstract DiagramVfsResolver<T> getVfsResolver();

    public abstract DiagramRelationshipManager<T> getRelationshipManager();

    @Nullable
    public DiagramPresentationModel createPresentationModel(Project project, Graph2D graph) {
        return null;
    }

    public abstract String getPresentableName();

    public abstract DiagramDataModel<T> createDataModel(@NotNull Project var1, @Nullable T var2, @Nullable VirtualFile var3, DiagramPresentationModel var4);

    public DiagramColorManager getColorManager() {
        return defaultColorManager;
    }

    @NotNull
    public DiagramExtras<T> getExtras() {
        DiagramExtras diagramExtras = new DiagramExtras();
        if (diagramExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramProvider", "getExtras"));
        }
        return diagramExtras;
    }

    public String getActionName(boolean isPopup) {
        return "Diagram";
    }

    public Icon getActionIcon(boolean isPopup) {
        return AllIcons.FileTypes.Diagram;
    }

    @Nullable
    public DiagramScopeManager<T> createScopeManager(Project project) {
        return null;
    }

    public List<String> getActionPlaces() {
        return Collections.emptyList();
    }

    @Nullable
    public DiagramEdgeCreationPolicy<T> getEdgeCreationPolicy() {
        return null;
    }

    @Nullable
    public static DiagramProvider findByID(String id) {
        for (DiagramProvider provider : (DiagramProvider[])DIAGRAM_PROVIDER.getExtensions()) {
            if (!provider.getID().equals(id)) continue;
            return provider;
        }
        return null;
    }

    public static boolean isEverybodyInThePlaceLetsGo(String place) {
        return ((Set)ourPlaces.getValue()).contains(place);
    }

    @Nullable
    public MessageBusListener<?> getMessageBusListener(final @NotNull Project project, final @NotNull Graph2D graph) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagram/DiagramProvider", "getMessageBusListener"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/diagram/DiagramProvider", "getMessageBusListener"));
        }
        return new MessageBusListener<PsiDocumentTransactionListener>(){

            @NotNull
            public Topic<PsiDocumentTransactionListener> getTopic() {
                Topic topic = PsiDocumentTransactionListener.TOPIC;
                if (topic == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramProvider$1", "getTopic"));
                }
                return topic;
            }

            @NotNull
            public PsiDocumentTransactionListener getListener() {
                PsiDocumentTransactionListener psiDocumentTransactionListener = new PsiDocumentTransactionListener(){

                    public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file) {
                        if (doc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/diagram/DiagramProvider$1$1", "transactionStarted"));
                        }
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diagram/DiagramProvider$1$1", "transactionStarted"));
                        }
                    }

                    public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file) {
                        if (doc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/diagram/DiagramProvider$1$1", "transactionCompleted"));
                        }
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diagram/DiagramProvider$1$1", "transactionCompleted"));
                        }
                        for (VirtualFile vf : FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
                            if (vf.getFileType() != DiagramFileType.INSTANCE) continue;
                            graph.updateViews();
                            return;
                        }
                    }
                };
                if (psiDocumentTransactionListener == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramProvider$1", "getListener"));
                }
                return psiDocumentTransactionListener;
            }
        };
    }

    public AnAction[] getCreateNewActions() {
        return DiagramCreateNewElementAction.EMPTY;
    }

    public AnAction[] getCreateNewNodeElementActions() {
        return DiagramCreateNewNodeElementAction.EMPTY;
    }

    public DiagramNodeIntentionAction<T>[] getNodeIntentionActions() {
        return DiagramNodeIntentionAction.EMPTY;
    }
}

