/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.diagram.components.DiagramNodeHeaderComponent;
import com.intellij.openapi.graph.builder.renderer.GradientFilledPanel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DiagramNodeContainer
extends JPanel {
    private final GradientFilledPanel myHeader;
    private final JPanel myBody;
    private final DiagramNode myNode;
    private BufferedImage myCache;
    private final DiagramNodeBodyComponent myNodeBodyComponent;

    public DiagramNodeContainer(DiagramNode node, DiagramBuilder builder, Point point) {
        super(new BorderLayout(0, 0));
        this.setFocusable(false);
        this.setBorder((Border)JBUI.Borders.empty());
        this.myNode = node;
        this.myHeader = new DiagramNodeHeaderComponent(node, builder);
        this.myBody = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myBody.setBorder((Border)JBUI.Borders.empty());
        this.myNodeBodyComponent = new DiagramNodeBodyComponent(this.myNode, builder, point);
        this.myBody.add((Component)((Object)this.myNodeBodyComponent));
        if (UIUtil.isUnderDarcula() && this.myNodeBodyComponent.getComponentCount() > 0) {
            this.myHeader.setBorder((Border)new CustomLineBorder((Color)(GraphViewUtil.isPrintMode() ? Gray._168 : Gray._90), 0, 0, 1, 0));
        }
        if (GraphViewUtil.isPrintMode() && this.myNodeBodyComponent.getComponentCount() == 0) {
            this.myHeader.setBorder(IdeBorderFactory.createEmptyBorder());
        }
        this.add((Component)this.getHeader(), "North");
        if (this.getBody().getComponentCount() > 0) {
            this.add((Component)this.getBody(), "Center");
        }
    }

    public JPanel getHeader() {
        return this.myHeader;
    }

    public JPanel getBody() {
        return this.myBody;
    }

    public DiagramNodeBodyComponent getNodeBodyComponent() {
        return this.myNodeBodyComponent;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Boolean isSelected = (Boolean)this.myNode.getUserData(DiagramNode.SELECTED_NODE_KEY);
        if (this.getClientProperty("cell.editor") == Boolean.TRUE || Registry.is((String)"diagrams.rendering.no.cache")) {
            if (isSelected != null && !isSelected.booleanValue()) {
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.4f));
            }
            super.paint(g);
            return;
        }
        if (this.myCache == null) {
            this.myCache = UIUtil.createImage((Graphics)g, (int)this.getWidth(), (int)this.getHeight(), (int)3);
            Graphics gg = this.myCache.getGraphics();
            if (isSelected != null && !isSelected.booleanValue()) {
                ((Graphics2D)gg).setComposite(AlphaComposite.getInstance(3, 0.4f));
            }
            super.paint(gg);
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myCache, (int)0, (int)0, (ImageObserver)this);
    }
}

