/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.presentation;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.Utils;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.presentation.EdgeInfo;
import com.intellij.diagram.presentation.SimpleElement;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.EdgeLayout;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NullUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramState
implements FileEditorState {
    private static final Logger LOG = Logger.getInstance(DiagramState.class);
    private final List<DiagramCategory> enabledCategories = new ArrayList<DiagramCategory>();
    private String currentVisibility = null;
    private String currentScope = null;
    private boolean isEdgeCreationMode = false;
    private boolean isFitContentAfterLayout = false;
    private DiagramLayout layout = DiagramLayout.HIERARCHIC_GROUP;
    private final Set<String> fqns = ContainerUtil.newLinkedHashSet();
    private final Map<String, Couple<Double>> nodesCoord = new HashMap<String, Couple<Double>>();
    private final Map<Couple<String>, EdgeInfo> edgesCoord = new HashMap<Couple<String>, EdgeInfo>();
    private final Set<String> selectedNodes = new HashSet<String>();
    private final Map<String, String> notes = new HashMap<String, String>();
    private final Map<String, Couple<Double>> notesCoord = new HashMap<String, Couple<Double>>();
    private final Map<String, EdgeInfo> noteEdgesCoord = new HashMap<String, EdgeInfo>();
    private double zoom = 1.0;
    private Point2D location = new Point(0, 0);
    private String providerID;
    private String originalFQN;
    @NonNls
    private static final String NODES = "nodes";
    @NonNls
    private static final String SETTINGS = "settings";
    @NonNls
    private static final String EDGES = "edges";
    @NonNls
    private static final String SELECTED_NODES = "SelectedNodes";
    @NonNls
    private static final String LAYOUT = "layout";
    @NonNls
    private static final String ZOOM = "zoom";
    @NonNls
    private static final String EDGE = "edge";
    @NonNls
    private static final String X = "x";
    @NonNls
    private static final String Y = "y";
    @NonNls
    private static final String NOTES = "notes";
    @NonNls
    private static final String NOTE = "note";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String SOURCE = "source";
    @NonNls
    private static final String TARGET = "target";
    @NonNls
    private static final String POINT = "point";
    @NonNls
    private static final String NODE = "node";
    @NonNls
    private static final String CATEGORIES = "Categories";
    private static final String CATEGORY = "Category";
    @NonNls
    private static final String ORIGINAL_ELEMENT = "OriginalElement";
    @NonNls
    private static final String ID = "ID";
    public static final String SCOPE = "SCOPE";
    public static final String VISIBILITY = "VISIBILITY";

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramState that = (DiagramState)o;
        if (this.isEdgeCreationMode != that.isEdgeCreationMode) {
            return false;
        }
        if (Double.compare(that.zoom, this.zoom) != 0) {
            return false;
        }
        if (this.currentScope != null ? !this.currentScope.equals(that.currentScope) : that.currentScope != null) {
            return false;
        }
        if (this.currentVisibility != null ? !this.currentVisibility.equals(that.currentVisibility) : that.currentVisibility != null) {
            return false;
        }
        if (!this.edgesCoord.equals(that.edgesCoord)) {
            return false;
        }
        if (!this.enabledCategories.equals(that.enabledCategories)) {
            return false;
        }
        if (!this.fqns.equals(that.fqns)) {
            return false;
        }
        if (!this.location.equals(that.location)) {
            return false;
        }
        if (!this.nodesCoord.equals(that.nodesCoord)) {
            return false;
        }
        if (!this.noteEdgesCoord.equals(that.noteEdgesCoord)) {
            return false;
        }
        if (!this.notes.equals(that.notes)) {
            return false;
        }
        if (!this.notesCoord.equals(that.notesCoord)) {
            return false;
        }
        if (!this.providerID.equals(that.providerID)) {
            return false;
        }
        return this.selectedNodes.equals(that.selectedNodes);
    }

    public boolean equalsIgnoreCoordinates(DiagramState that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!this.enabledCategories.equals(that.enabledCategories)) {
            return false;
        }
        if (!this.fqns.equals(that.fqns)) {
            return false;
        }
        if (!this.notes.equals(that.notes)) {
            return false;
        }
        if (!this.providerID.equals(that.providerID)) {
            return false;
        }
        return this.selectedNodes.equals(that.selectedNodes);
    }

    public int hashCode() {
        int result = this.enabledCategories.hashCode();
        result = 31 * result + (this.isEdgeCreationMode ? 1 : 0);
        result = 31 * result + this.fqns.hashCode();
        result = 31 * result + this.nodesCoord.hashCode();
        result = 31 * result + this.edgesCoord.hashCode();
        result = 31 * result + this.selectedNodes.hashCode();
        result = 31 * result + this.notes.hashCode();
        result = 31 * result + this.notesCoord.hashCode();
        result = 31 * result + this.noteEdgesCoord.hashCode();
        long temp = this.zoom != 0.0 ? Double.doubleToLongBits(this.zoom) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.location.hashCode();
        result = 31 * result + this.providerID.hashCode();
        return result;
    }

    public DiagramState(DiagramProvider provider) {
        this.providerID = provider == null ? null : provider.getID();
        DiagramConfiguration conf = DiagramConfiguration.getConfiguration();
        if (provider != null) {
            for (DiagramCategory category : provider.getNodeContentManager().getContentCategories()) {
                if (!conf.isEnabledByDefault(provider, category.getName())) continue;
                this.enabledCategories.add(category);
            }
        }
        this.currentScope = DiagramConfiguration.getConfiguration().defaultScope;
    }

    public DiagramState() {
        this((DiagramProvider)null);
    }

    public DiagramState(DiagramBuilder builder) {
        this(builder.getProvider());
        this.update(builder, true);
    }

    public void copyFrom(@NotNull DiagramState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diagram/presentation/DiagramState", "copyFrom"));
        }
        if (this == state) {
            return;
        }
        this.enabledCategories.clear();
        this.enabledCategories.addAll(state.enabledCategories);
        this.isEdgeCreationMode = state.isEdgeCreationMode;
        this.layout = state.layout;
        this.isFitContentAfterLayout = state.isFitContentAfterLayout;
        this.selectedNodes.clear();
        this.selectedNodes.addAll(state.selectedNodes);
        this.nodesCoord.clear();
        this.nodesCoord.putAll(state.nodesCoord);
        this.notes.clear();
        this.notes.putAll(state.notes);
        this.notesCoord.clear();
        this.notesCoord.putAll(state.notesCoord);
        this.fqns.clear();
        this.fqns.addAll(state.fqns);
        this.edgesCoord.clear();
        this.edgesCoord.putAll(state.edgesCoord);
        this.noteEdgesCoord.clear();
        this.noteEdgesCoord.putAll(state.noteEdgesCoord);
        this.location = state.location;
        this.zoom = state.zoom;
        this.currentScope = state.currentScope;
        this.currentVisibility = state.currentVisibility;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String id) {
        this.providerID = id;
    }

    @Nullable
    public EdgeInfo getEdgeInfo(String src, String trg) {
        return this.edgesCoord.get(Couple.of((Object)src, (Object)trg));
    }

    public EdgeInfo getNoteEdgeCoord(String fqn) {
        return this.noteEdgesCoord.get(fqn);
    }

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public Map<String, Couple<Double>> getNotesCoord() {
        return this.notesCoord;
    }

    public DiagramLayout getLayout() {
        return this.layout;
    }

    public void setLayout(DiagramLayout layout) {
        if (this.layout != layout) {
            this.layout = layout;
        }
    }

    public boolean isFitContentAfterLayout() {
        return this.isFitContentAfterLayout;
    }

    public void setFitContentAfterLayout(boolean enabled) {
        this.isFitContentAfterLayout = enabled;
    }

    public boolean isCategoryEnabled(DiagramCategory category) {
        return this.enabledCategories.contains(category);
    }

    public void setCategoryEnabled(DiagramCategory category, boolean enabled) {
        if (enabled) {
            if (!this.enabledCategories.contains(category)) {
                this.enabledCategories.add(category);
            }
        } else {
            this.enabledCategories.remove(category);
        }
    }

    public DiagramCategory[] getEnabledCategories() {
        return this.enabledCategories.toArray(new DiagramCategory[this.enabledCategories.size()]);
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public void update(DiagramBuilder builder, boolean updateCategories) {
        YPoint point;
        Node n;
        String fqn;
        this.fqns.clear();
        this.selectedNodes.clear();
        this.nodesCoord.clear();
        this.edgesCoord.clear();
        this.noteEdgesCoord.clear();
        this.notes.clear();
        this.notesCoord.clear();
        this.zoom = builder.getView().getZoom();
        this.location = builder.getView().getCenter();
        if (updateCategories) {
            List<DiagramCategory> categories = builder.getPresentation().enabledCategories;
            this.enabledCategories.clear();
            this.enabledCategories.addAll(categories);
        }
        DiagramDataModel model = builder.getDataModel();
        DiagramProvider umlProvider = builder.getProvider();
        DiagramVfsResolver resolver = umlProvider.getVfsResolver();
        this.providerID = umlProvider.getID();
        DiagramScopeManager scopeManager = model.getScopeManager();
        NamedScope scope = scopeManager == null ? null : scopeManager.getCurrentScope();
        this.currentScope = scope == null ? null : scope.getName();
        VisibilityLevel level = model.getVisibilityManager().getCurrentVisibilityLevel();
        this.currentVisibility = level == null ? null : level.getName();
        for (DiagramNode node : model.getNodes()) {
            fqn = resolver.getQualifiedName(node.getIdentifyingElement());
            if (fqn == null) continue;
            this.fqns.add(fqn);
            n = builder.getNode(node);
            if (n == null) continue;
            point = builder.getGraph().getLocation(n);
            this.nodesCoord.put(fqn, (Couple<Double>)Couple.of((Object)point.getX(), (Object)point.getY()));
            if (!builder.getGraph().isSelected(n)) continue;
            this.selectedNodes.add(fqn);
        }
        for (DiagramNoteNode note : model.getNotes().values()) {
            fqn = resolver.getQualifiedName(note.getIdentifyingElement().getIdentifyingElement());
            if (fqn == null || !this.fqns.contains(fqn) || (n = builder.getNode(note)) == null) continue;
            point = builder.getGraph().getLocation(n);
            this.notesCoord.put(fqn, (Couple<Double>)Couple.of((Object)point.getX(), (Object)point.getY()));
            this.notes.put(fqn, note.getTooltip());
        }
        for (DiagramEdge umlEdge : builder.getEdgeObjects()) {
            Edge edge = builder.getEdge(umlEdge);
            Utils.assertForgetToRemoveEdge(edge, umlEdge, builder);
            EdgeLayout edgeLayout = builder.getGraph().getEdgeLayout((Object)edge);
            if (edgeLayout == null) continue;
            EdgeInfo info = new EdgeInfo(umlEdge, builder);
            if (umlEdge instanceof DiagramNoteEdge) {
                this.noteEdgesCoord.put(info.getSrc(), info);
                continue;
            }
            this.edgesCoord.put((Couple<String>)Couple.of((Object)info.getSrc(), (Object)info.getTrg()), info);
        }
    }

    public String[] getFQNs() {
        return ArrayUtil.toStringArray(this.fqns);
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        return false;
    }

    public String getNodeX(String fqn) {
        Couple<Double> coord = this.nodesCoord.get(fqn);
        return coord == null ? "" : String.valueOf(coord.getFirst());
    }

    public String getNodeY(String fqn) {
        Couple<Double> coord = this.nodesCoord.get(fqn);
        return coord == null ? "" : String.valueOf(coord.getSecond());
    }

    public String[] getSelectedNodes() {
        return ArrayUtil.toStringArray(this.selectedNodes);
    }

    public Point2D getCenter() {
        return this.location;
    }

    public void setCenter(Point2D point) {
        this.location = point;
    }

    public void addFQN(String fqn) {
        this.fqns.add(fqn);
    }

    public void setNodeCoord(String fqn, double x, double y) {
        this.nodesCoord.put(fqn, (Couple<Double>)Couple.of((Object)x, (Object)y));
    }

    public void setSelectedNodes(List<String> selNodes) {
        this.selectedNodes.clear();
        this.selectedNodes.addAll(selNodes);
    }

    public void setCategories(Set<DiagramCategory> cats) {
        this.enabledCategories.clear();
        this.enabledCategories.addAll(cats);
    }

    public EdgeInfo[] getEdgeInfos() {
        Collection<EdgeInfo> edgeInfos = this.edgesCoord.values();
        return edgeInfos.toArray(new EdgeInfo[edgeInfos.size()]);
    }

    public void setEdgesCoord(@NotNull String srcFqn, @NotNull String trgFqn, @NotNull List<Couple<Double>> edgeCoord) {
        if (srcFqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcFqn", "com/intellij/diagram/presentation/DiagramState", "setEdgesCoord"));
        }
        if (trgFqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trgFqn", "com/intellij/diagram/presentation/DiagramState", "setEdgesCoord"));
        }
        if (edgeCoord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgeCoord", "com/intellij/diagram/presentation/DiagramState", "setEdgesCoord"));
        }
        this.edgesCoord.put((Couple<String>)Couple.of((Object)srcFqn, (Object)trgFqn), new EdgeInfo(srcFqn, trgFqn, edgeCoord));
    }

    public void setNoteEdgeCoord(@NotNull String fqn, @NotNull List<Couple<Double>> edgeCoord) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/diagram/presentation/DiagramState", "setNoteEdgeCoord"));
        }
        if (edgeCoord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgeCoord", "com/intellij/diagram/presentation/DiagramState", "setNoteEdgeCoord"));
        }
        this.noteEdgesCoord.put(fqn, new EdgeInfo(fqn, null, edgeCoord));
    }

    public String getOriginalFQN() {
        return this.originalFQN;
    }

    public void setOriginalFQN(String originalFQN) {
        this.originalFQN = originalFQN;
    }

    public String getCurrentVisibility() {
        return this.currentVisibility;
    }

    public void setCurrentVisibility(String currentVisibility) {
        this.currentVisibility = currentVisibility;
    }

    public String getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(String currentScope) {
        this.currentScope = currentScope;
    }

    public void restoreTo(DiagramBuilder builder) {
        DiagramVfsResolver resolver = builder.getProvider().getVfsResolver();
        Graph2D graph = builder.getGraph();
        builder.getView().setZoom(this.getZoom());
        builder.getView().setCenter(this.getCenter().getX(), this.getCenter().getY());
        HashMap<DiagramNode, String> fqnCache = new HashMap<DiagramNode, String>();
        for (DiagramNode node : builder.getNodeObjects()) {
            String fqn;
            if (node instanceof DiagramNoteNode) {
                fqn = resolver.getQualifiedName(((DiagramNoteNode)node).getIdentifyingElement().getIdentifyingElement());
                try {
                    Couple<Double> pair = this.getNotesCoord().get(fqn);
                    graph.setLocation(builder.getNode(node), ((Double)pair.first).doubleValue(), ((Double)pair.second).doubleValue());
                }
                catch (Exception pair) {}
                continue;
            }
            fqn = resolver.getQualifiedName(node.getIdentifyingElement());
            if (fqn != null) {
                fqnCache.put(node, fqn);
            }
            try {
                double x = Double.parseDouble(this.getNodeX(fqn));
                double y = Double.parseDouble(this.getNodeY(fqn));
                graph.setLocation(builder.getNode(node), x, y);
            }
            catch (Exception exception) {}
        }
        this.updateEdges(builder, graph, fqnCache, true);
    }

    public void updateEdges(@NotNull DiagramBuilder builder, @NotNull Graph2D graph, @NotNull Map<DiagramNode, String> fqnCache, boolean clear) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/diagram/presentation/DiagramState", "updateEdges"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/diagram/presentation/DiagramState", "updateEdges"));
        }
        if (fqnCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqnCache", "com/intellij/diagram/presentation/DiagramState", "updateEdges"));
        }
        for (DiagramEdge umlEdge : builder.getEdgeObjects()) {
            EdgeInfo info;
            if (umlEdge instanceof DiagramNoteEdge) {
                String fqn = fqnCache.get(umlEdge.getSource());
                info = this.getNoteEdgeCoord(fqn);
            } else {
                String src = fqnCache.get(umlEdge.getSource());
                String trg = fqnCache.get(umlEdge.getTarget());
                info = this.getEdgeInfo(src, trg);
            }
            Edge edge = builder.getEdge(umlEdge);
            if (info != null && edge != null && info.getPoints().size() > 1) {
                List<Couple<Double>> points = info.getPoints();
                EdgeLayout edgeLayout = graph.getEdgeLayout((Object)edge);
                if (edgeLayout == null) continue;
                edgeLayout.clearPoints();
                YPoint srcP = GraphManager.getGraphManager().createYPoint(((Double)points.get(0).getFirst()).doubleValue(), ((Double)points.get(0).getSecond()).doubleValue());
                YPoint trgP = GraphManager.getGraphManager().createYPoint(((Double)points.get(points.size() - 1).getFirst()).doubleValue(), ((Double)points.get(points.size() - 1).getSecond()).doubleValue());
                edgeLayout.setSourcePoint(srcP);
                edgeLayout.setTargetPoint(trgP);
                for (int i = 1; i < points.size() - 1; ++i) {
                    edgeLayout.addPoint(((Double)points.get(i).getFirst()).doubleValue(), ((Double)points.get(i).getSecond()).doubleValue());
                }
                continue;
            }
            if (!clear || edge == null) continue;
            graph.getEdgeLayout((Object)edge).clearPoints();
        }
    }

    public void write(Element root) {
        DiagramState state = this;
        Element id = new Element(ID);
        id.setText(state.getProviderID());
        root.addContent(id);
        Element originalFQN = new Element(ORIGINAL_ELEMENT);
        originalFQN.setText(state.getOriginalFQN());
        root.addContent(originalFQN);
        Element fqns = new Element(NODES);
        for (String fqn : state.getFQNs()) {
            SimpleElement simpleElement = new SimpleElement(NODE, X, state.getNodeX(fqn), Y, state.getNodeY(fqn));
            simpleElement.setText(fqn);
            fqns.addContent((Element)simpleElement);
        }
        root.addContent(fqns);
        Element notesNode = new Element(NOTES);
        Map<String, Couple<Double>> notesCoord = state.getNotesCoord();
        Map<String, String> notes = state.getNotes();
        for (String string : notes.keySet()) {
            Couple<Double> pair = notesCoord.get(string);
            if (pair == null) continue;
            SimpleElement note = new SimpleElement(NOTE, X, String.valueOf(pair.first), Y, String.valueOf(pair.second));
            Element node = new Element(NODE);
            node.setText(string);
            note.addContent(node);
            Element value = new Element(VALUE);
            value.setText(StringUtil.escapeStringCharacters((String)notes.get(string)));
            note.addContent(value);
            Element edge = new Element(EDGE);
            for (Couple<Double> p : state.getNoteEdgeCoord(string).getPoints()) {
                edge.addContent((Element)new SimpleElement(POINT, X, ((Double)p.getFirst()).toString(), Y, ((Double)p.getSecond()).toString()));
            }
            note.addContent(edge);
            notesNode.addContent((Element)note);
        }
        root.addContent(notesNode);
        Element edges = new Element(EDGES);
        for (EdgeInfo edgeInfo : state.getEdgeInfos()) {
            SimpleElement edge = new SimpleElement(EDGE, SOURCE, edgeInfo.getSrc(), TARGET, edgeInfo.getTrg());
            for (Couple<Double> p : edgeInfo.getPoints()) {
                edge.addContent(new SimpleElement(POINT, X, ((Double)p.getFirst()).toString(), Y, ((Double)p.getSecond()).toString()));
            }
            edges.addContent((Element)edge);
        }
        root.addContent(edges);
        SimpleElement simpleElement = new SimpleElement(SETTINGS, LAYOUT, state.getLayout().getPresentableName(), ZOOM, String.valueOf(state.getZoom()), X, String.valueOf(state.getCenter().getX()), Y, String.valueOf(state.getCenter().getY()));
        root.addContent((Element)simpleElement);
        Element selectedNodes = new Element(SELECTED_NODES);
        for (String fqn : state.getSelectedNodes()) {
            Element child = new Element(NODE);
            child.setText(fqn);
            selectedNodes.addContent(child);
        }
        root.addContent(selectedNodes);
        Element categories = new Element(CATEGORIES);
        for (DiagramCategory category : state.getEnabledCategories()) {
            Element cat = new Element(CATEGORY);
            cat.setText(category.getName());
            categories.addContent(cat);
        }
        root.addContent(categories);
        if (state.getCurrentScope() != null) {
            Element scope = new Element(SCOPE);
            scope.setText(state.getCurrentScope());
            root.addContent(scope);
        }
        if (state.getCurrentVisibility() != null) {
            Element visibility = new Element(VISIBILITY);
            visibility.setText(state.getCurrentVisibility());
            root.addContent(visibility);
        }
    }

    public static DiagramState read(InputStream stream) throws IOException, JDOMException {
        return DiagramState.read(new SAXBuilder().build(stream).getRootElement());
    }

    public static DiagramState read(@NotNull Element root) {
        Element scope;
        Element visibility;
        Element categories;
        Element edges;
        Element selectedNodes;
        Element settings;
        Element notes;
        Element nodes;
        Element originalFQN;
        DiagramProvider provider;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/diagram/presentation/DiagramState", "read"));
        }
        DiagramState state = new DiagramState();
        Element providerID = root.getChild(ID);
        String id = providerID.getText();
        DiagramProvider diagramProvider = provider = id == null ? null : DiagramProvider.findByID(id);
        if (provider != null) {
            state.setProviderID(provider.getID());
        }
        if ((originalFQN = root.getChild(ORIGINAL_ELEMENT)) != null) {
            state.setOriginalFQN(originalFQN.getText());
        }
        if ((nodes = root.getChild(NODES)) != null) {
            for (Object e : nodes.getChildren()) {
                String fqn;
                if (!(e instanceof Element) || (fqn = ((Element)e).getText()) == null) continue;
                state.addFQN(fqn);
                try {
                    double x = Double.parseDouble(((Element)e).getAttributeValue(X));
                    double y = Double.parseDouble(((Element)e).getAttributeValue(Y));
                    state.setNodeCoord(fqn, x, y);
                }
                catch (Exception x) {}
            }
        }
        if ((notes = root.getChild(NOTES)) != null) {
            for (Object e : notes.getChildren()) {
                Attribute y;
                Attribute x;
                String fqn;
                Element note;
                Iterator value;
                if (!(e instanceof Element) || !NullUtils.notNull((Object[])new Object[]{value = (note = (Element)e).getChild(VALUE) == null ? null : StringUtil.unescapeStringCharacters((String)note.getChild(VALUE).getValue()), fqn = note.getChild(NODE) == null ? null : note.getChild(NODE).getValue(), x = note.getAttribute(X), y = note.getAttribute(Y)})) continue;
                state.getNotes().put(fqn, (String)((Object)value));
                state.getNotesCoord().put(fqn, (Couple<Double>)Couple.of((Object)DiagramState.getDouble(x, 0.0), (Object)DiagramState.getDouble(y, 0.0)));
                Element points = note.getChild(EDGE);
                if (points == null) continue;
                ArrayList<Couple<Double>> coords = new ArrayList<Couple<Double>>();
                for (Object child : points.getChildren()) {
                    if (!(child instanceof Element)) continue;
                    Element p = (Element)child;
                    try {
                        coords.add((Couple<Double>)Couple.of((Object)Double.parseDouble(p.getAttributeValue(X)), (Object)Double.parseDouble(p.getAttributeValue(Y))));
                    }
                    catch (Exception exception) {}
                }
                state.setNoteEdgeCoord(fqn, coords);
            }
        }
        if ((settings = root.getChild(SETTINGS)) != null) {
            state.setLayout(DiagramLayout.fromString(settings.getAttributeValue(LAYOUT)));
            state.setZoom(DiagramState.getDouble(settings.getAttribute(ZOOM), 1.0));
            Point p = new Point();
            p.setLocation(DiagramState.getDouble(settings.getAttribute(X), 0.0), DiagramState.getDouble(settings.getAttribute(Y), 0.0));
            state.setCenter(p);
        }
        if ((selectedNodes = root.getChild(SELECTED_NODES)) != null) {
            ArrayList<String> selNodes = new ArrayList<String>();
            for (Object child : selectedNodes.getChildren()) {
                String fqn;
                if (!(child instanceof Element) || (fqn = ((Element)child).getText()) == null) continue;
                selNodes.add(fqn);
            }
            state.setSelectedNodes(selNodes);
        }
        if ((edges = root.getChild(EDGES)) != null) {
            for (Object e : edges.getChildren()) {
                if (!(e instanceof Element)) continue;
                Element edge = (Element)e;
                String src = edge.getAttributeValue(SOURCE);
                String trg = edge.getAttributeValue(TARGET);
                if (src == null || trg == null) continue;
                ArrayList<Couple<Double>> points = new ArrayList<Couple<Double>>();
                for (Object point : edge.getChildren()) {
                    if (!(point instanceof Element)) continue;
                    try {
                        double x = Double.parseDouble(((Element)point).getAttributeValue(X));
                        double y = Double.parseDouble(((Element)point).getAttributeValue(Y));
                        points.add((Couple<Double>)Couple.of((Object)x, (Object)y));
                    }
                    catch (Exception exception) {}
                }
                if (points.size() <= 1) continue;
                state.setEdgesCoord(src, trg, points);
            }
        }
        if ((categories = root.getChild(CATEGORIES)) != null && provider != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (Object child : categories.getChildren(CATEGORY)) {
                if (!(child instanceof Element)) continue;
                names.add(((Element)child).getText());
            }
            HashSet<DiagramCategory> cats = new HashSet<DiagramCategory>();
            for (DiagramCategory category : provider.getNodeContentManager().getContentCategories()) {
                if (!names.contains(category.getName())) continue;
                cats.add(category);
            }
            state.setCategories(cats);
        }
        if ((visibility = root.getChild(VISIBILITY)) != null) {
            state.setCurrentVisibility(visibility.getText());
        }
        if ((scope = root.getChild(SCOPE)) != null) {
            state.setCurrentScope(scope.getText());
        }
        return state;
    }

    private static double getDouble(Attribute attr, double defaultValue) {
        try {
            return Double.parseDouble(attr.getValue());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean saveTo(VirtualFile file, Project project) {
        Document xml = new Document(new Element("Diagram"));
        this.write(xml.getRootElement());
        return DiagramState.writeXml(file, project, xml);
    }

    public static boolean writeXml(VirtualFile to, Project project, Document xml) {
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{to});
        if (status.hasReadonlyFiles()) {
            return false;
        }
        return (Boolean)WriteAction.compute(() -> {
            try {
                OutputStream os = to.getOutputStream(null);
                XMLOutputter out = new XMLOutputter();
                String separator = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getLineSeparator();
                out.setFormat(Format.getPrettyFormat().setLineSeparator(separator));
                out.output(xml, os);
                os.close();
            }
            catch (Exception e1) {
                LOG.error((Throwable)e1);
                return false;
            }
            return true;
        });
    }
}

