/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.ClassProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

class JarArchive
implements ClassProvider {
    private final ZipFile myZip;

    JarArchive(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/zkm/bytecode/JarArchive", "<init>"));
        }
        this.myZip = new ZipFile(file);
    }

    @Override
    public boolean contains(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/zkm/bytecode/JarArchive", "contains"));
        }
        return this.entryFor(className) != null;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull String className) throws IOException {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/zkm/bytecode/JarArchive", "getInputStream"));
        }
        ZipEntry entry = this.entryFor(className);
        if (entry == null) {
            throw new NoSuchElementException(className);
        }
        InputStream inputStream = this.myZip.getInputStream(entry);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/JarArchive", "getInputStream"));
        }
        return inputStream;
    }

    private static String pathTo(String className) {
        return className.replace('.', '/') + ".class";
    }

    private ZipEntry entryFor(String className) {
        return this.myZip.getEntry(JarArchive.pathTo(className));
    }

    public void close() throws IOException {
        this.myZip.close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

