/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.BytecodeImpl;
import com.intellij.zkm.bytecode.Changelog;
import com.intellij.zkm.bytecode.ChangelogReader;
import com.intellij.zkm.bytecode.InvocationReaderImpl;
import com.intellij.zkm.bytecode.JarArchive;
import com.intellij.zkm.bytecode.SignatureReaderImpl;
import com.intellij.zkm.bytecode.Translator;
import com.intellij.zkm.bytecode.TranslatorImpl;
import com.intellij.zkm.bytecode.TypeFactory;
import com.intellij.zkm.bytecode.TypeFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

class TranslatorFactory {
    private static SoftReference<TypeFactory> ourTypeFactory;
    private static final Map<File, SoftReference<Translator>> ourTranslators;

    TranslatorFactory() {
    }

    @NotNull
    public static Translator create(@NotNull File logFile, @NotNull File bytecodeFile) throws IOException {
        Translator translator;
        if (logFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logFile", "com/intellij/zkm/bytecode/TranslatorFactory", "create"));
        }
        if (bytecodeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytecodeFile", "com/intellij/zkm/bytecode/TranslatorFactory", "create"));
        }
        SoftReference<Translator> reference = ourTranslators.get(logFile);
        if (reference != null && (translator = reference.get()) != null) {
            Translator translator2 = translator;
            if (translator2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/TranslatorFactory", "create"));
            }
            return translator2;
        }
        translator = TranslatorFactory.doCreate(logFile, bytecodeFile);
        ourTranslators.put(logFile, new SoftReference<Translator>(translator));
        Translator translator3 = translator;
        if (translator3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/TranslatorFactory", "create"));
        }
        return translator3;
    }

    private static Translator doCreate(File logFile, File bytecodeFile) throws IOException {
        Changelog changelog;
        TypeFactory typeFactory = TranslatorFactory.getTypeFactory();
        try (ZipFile zip = new ZipFile(logFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(zip.getEntry("ChangeLog.txt"))));){
            changelog = new ChangelogReader(typeFactory).read(reader);
        }
        BytecodeImpl bytecode = new BytecodeImpl(new JarArchive(bytecodeFile), new SignatureReaderImpl(typeFactory), new InvocationReaderImpl(typeFactory));
        return new TranslatorImpl(changelog, bytecode);
    }

    @NotNull
    private static TypeFactory getTypeFactory() {
        TypeFactory typeFactory;
        TypeFactory typeFactory2 = typeFactory = ourTypeFactory == null ? null : ourTypeFactory.get();
        if (typeFactory == null) {
            typeFactory = new TypeFactoryImpl();
            ourTypeFactory = new SoftReference<TypeFactory>(typeFactory);
        }
        TypeFactory typeFactory3 = typeFactory;
        if (typeFactory3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/TranslatorFactory", "getTypeFactory"));
        }
        return typeFactory3;
    }

    static {
        ourTranslators = new HashMap<File, SoftReference<Translator>>();
    }
}

