/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.refs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class JavaFxCssIdSelectorReference
extends PsiPolyVariantReferenceBase<XmlAttributeValue> {
    public JavaFxCssIdSelectorReference(@NotNull XmlAttributeValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCssIdSelectorReference", "<init>"));
        }
        super((PsiElement)value, true);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String fxId = ((XmlAttributeValue)this.myElement).getValue();
        if (StringUtil.isEmpty((String)fxId)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCssIdSelectorReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Set<PsiFile> cssFiles = JavaFxCssIdSelectorReference.getImportedCssFiles(this.myElement);
        if (cssFiles.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCssIdSelectorReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List virtualFiles = cssFiles.stream().map(PsiUtilCore::getVirtualFile).filter(Objects::nonNull).collect(Collectors.toList());
        Project project = ((XmlAttributeValue)this.myElement).getProject();
        GlobalSearchScope cssFilesScope = GlobalSearchScope.filesScope((Project)project, virtualFiles);
        ArrayList resolveResults = new ArrayList();
        CssIndexUtil.processIds((String)fxId, (Project)project, (GlobalSearchScope)cssFilesScope, (name, suffix) -> {
            if (suffix instanceof CssIdSelector) {
                resolveResults.add(new PsiElementResolveResult((PsiElement)suffix));
            }
            return true;
        });
        ResolveResult[] resolveResultArray = resolveResults.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCssIdSelectorReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return super.handleElementRename(newElementName);
    }

    private static Set<PsiFile> getImportedCssFiles(PsiElement element) {
        XmlTag start = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        final THashSet result = new THashSet();
        for (XmlTag tag = start; tag != null; tag = tag.getParentTag()) {
            XmlTag[] subTags;
            XmlAttribute attribute = tag.getAttribute("stylesheets");
            if (attribute != null) {
                JavaFxCssIdSelectorReference.addImportedCssFiles(attribute, (Set<PsiFile>)result);
            }
            for (XmlTag subTag : subTags = tag.findSubTags("stylesheets")) {
                subTag.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttribute(XmlAttribute attribute) {
                        JavaFxCssIdSelectorReference.addImportedCssFiles(attribute, (Set)result);
                    }
                });
            }
        }
        return result;
    }

    private static void addImportedCssFiles(XmlAttribute attribute, Set<PsiFile> result) {
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement != null) {
            PsiReference[] references;
            for (PsiReference reference : references = valueElement.getReferences()) {
                PsiFile file;
                PsiElement resolved = reference.resolve();
                if (!(resolved instanceof PsiFile) || (file = (PsiFile)resolved).getFileType() != CssFileType.INSTANCE) continue;
                result.add(file);
            }
        }
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCssIdSelectorReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

