/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxScopeEnlarger;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;
import org.jetbrains.plugins.javaFX.indexing.JavaFxIdsIndex;

public class JavaFxImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof PsiMethod) {
            return JavaFxImplicitUsageProvider.isImplicitMethodUsage((PsiMethod)element);
        }
        return this.isImplicitWrite(element);
    }

    private static boolean isImplicitMethodUsage(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxImplicitUsageProvider", "isImplicitMethodUsage"));
        }
        if (!JavaFxImplicitUsageProvider.isImplicitFxmlAccess((PsiModifierListOwner)method)) {
            return false;
        }
        if (JavaFxImplicitUsageProvider.isInvokedByFxmlLoader(method)) {
            return true;
        }
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)method.getProject());
        JavaFxScopeEnlarger.GlobalFxmlSearchScope fxmlScope = new JavaFxScopeEnlarger.GlobalFxmlSearchScope(projectScope);
        return JavaFxImplicitUsageProvider.isFxmlUsage((PsiMember)method, (GlobalSearchScope)fxmlScope);
    }

    private static boolean isFxmlUsage(PsiMember member, GlobalSearchScope scope) {
        PsiSearchHelper.SearchCostResult searchCost;
        String name = member.getName();
        if (name == null) {
            return false;
        }
        Project project = member.getProject();
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)project);
        PsiSearchHelper.SearchCostResult searchCostResult = searchCost = RefResolveService.getInstance((Project)project).isUpToDate() ? PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES : searchHelper.isCheapEnoughToSearch(name, scope, null, null);
        if (searchCost == PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) {
            Query query = ReferencesSearch.search((PsiElement)member, (SearchScope)scope);
            return query.findFirst() != null;
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            if (!JavaFxImplicitUsageProvider.isImplicitFxmlAccess((PsiModifierListOwner)field)) {
                return false;
            }
            String fieldName = field.getName();
            if (fieldName == null) {
                return false;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            Project project = element.getProject();
            if (JavaFxImplicitUsageProvider.isInjectedByFxmlLoader(field)) {
                return true;
            }
            Collection<VirtualFile> containingFiles = JavaFxIdsIndex.getContainingFiles(project, fieldName);
            if (containingFiles.isEmpty()) {
                return false;
            }
            List<VirtualFile> fxmls = JavaFxControllerClassIndex.findFxmlsWithController(project, qualifiedName);
            for (VirtualFile fxml : fxmls) {
                if (!containingFiles.contains(fxml)) continue;
                return true;
            }
            return JavaFxImplicitUsageProvider.isFxmlUsage((PsiMember)field, GlobalSearchScope.filesScope((Project)project, containingFiles));
        }
        return false;
    }

    private static boolean isInvokedByFxmlLoader(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxImplicitUsageProvider", "isInvokedByFxmlLoader"));
        }
        return "initialize".equals(method.getName()) && method.getParameterList().getParametersCount() == 0 && JavaFxImplicitUsageProvider.isDeclaredInControllerClass((PsiMember)method);
    }

    private static boolean isInjectedByFxmlLoader(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxImplicitUsageProvider", "isInjectedByFxmlLoader"));
        }
        String fieldName = field.getName();
        PsiType fieldType = field.getType();
        return fieldName != null && ("resources".equals(fieldName) && InheritanceUtil.isInheritor((PsiType)fieldType, (String)"java.util.ResourceBundle") || "location".equals(fieldName) && InheritanceUtil.isInheritor((PsiType)fieldType, (String)"java.net.URL")) && JavaFxImplicitUsageProvider.isDeclaredInControllerClass((PsiMember)field);
    }

    private static boolean isDeclaredInControllerClass(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxImplicitUsageProvider", "isDeclaredInControllerClass"));
        }
        PsiClass containingClass = member.getContainingClass();
        String qualifiedName = containingClass != null ? containingClass.getQualifiedName() : null;
        return qualifiedName != null && !JavaFxControllerClassIndex.findFxmlsWithController(member.getProject(), qualifiedName).isEmpty();
    }

    private static boolean isImplicitFxmlAccess(PsiModifierListOwner member) {
        return !member.hasModifierProperty("public") && AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)"javafx.fxml.FXML", (boolean)false);
    }
}

