/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class UnwrapTagFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(UnwrapTagFix.class);
    private final String myTagName;

    public UnwrapTagFix(String tagName) {
        this.myTagName = tagName;
    }

    @NotNull
    public String getName() {
        String string = "Unwrap '" + this.myTagName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/UnwrapTagFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Unwrap tag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/UnwrapTagFix", "getFamilyName"));
        }
        return "Unwrap tag";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/UnwrapTagFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/UnwrapTagFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element != null) {
            PsiFile containingFile = element.getContainingFile();
            LOG.assertTrue(containingFile != null && JavaFxFileTypeFactory.isFxml(containingFile), (Object)(containingFile == null ? "no containing file found" : "containing file: " + containingFile.getName()));
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
            if (xmlTag != null) {
                XmlTag parentTag = xmlTag.getParentTag();
                PsiElement[] children = PsiTreeUtil.getChildrenOfType((PsiElement)xmlTag, XmlTagChild.class);
                if (children != null && children.length > 0 && parentTag != null) {
                    parentTag.addRange(children[0], children[children.length - 1]);
                }
                xmlTag.delete();
                if (parentTag != null) {
                    CodeStyleManager.getInstance((Project)project).reformat((PsiElement)parentTag, true);
                }
            }
        }
    }
}

