/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor.wrapper;

import com.intellij.dmserver.editor.wrapper.ClauseWrapper;
import com.intellij.dmserver.util.ManifestUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.lang.manifest.psi.Header;
import org.osmorc.manifest.lang.psi.Clause;

public class HeaderWrapper {
    private final String myName;
    private final List<ClauseWrapper> myClauses;

    public HeaderWrapper(PsiFile manifestFile, String headerName) {
        this.myName = headerName;
        this.myClauses = new ArrayList<ClauseWrapper>();
        List<Header> headers = ManifestUtils.getInstance().findHeaders(manifestFile, headerName);
        for (Header header : headers) {
            Clause clause = (Clause)PsiTreeUtil.getChildOfType((PsiElement)header, Clause.class);
            while (clause != null) {
                ClauseWrapper clauseWrapper = ClauseWrapper.create(clause);
                if (clauseWrapper != null) {
                    this.myClauses.add(clauseWrapper);
                }
                clause = (Clause)PsiTreeUtil.getNextSiblingOfType((PsiElement)clause, Clause.class);
            }
        }
    }

    public String getName() {
        return this.myName;
    }

    public List<ClauseWrapper> getClauses() {
        return this.myClauses;
    }
}

