/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.InputStream;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpStreamObserver;
import org.w3c.www.http.ParseState;

public class ChunkedInputStream
extends InputStream {
    protected InputStream in = null;
    protected HttpBuffer buf = null;
    protected ParseState ps = null;
    protected boolean inited = false;
    protected int clen = -1;
    protected int ahead = -1;
    protected boolean isahead = false;
    protected boolean eof = false;
    protected HttpStreamObserver observer = null;

    private final void checkInit() throws IOException {
        if (!this.inited) {
            this.clen = this.nextChunk(false);
            this.inited = true;
        }
    }

    protected int nextChunk(boolean bl) throws IOException {
        if (this.eof) {
            return 0;
        }
        int n = -1;
        this.buf.reset();
        if (bl) {
            n = this.in.read();
            n = this.in.read();
        }
        block5: while (true) {
            n = this.in.read();
            switch (n) {
                case -1: {
                    throw new IOException("Premature end of chunked stream.");
                }
                case 13: {
                    n = this.in.read();
                    if (n == 10) break block5;
                    this.ahead = n;
                    this.isahead = true;
                    break block5;
                }
                case 10: {
                    break block5;
                }
                default: {
                    this.buf.append(n);
                    continue block5;
                }
            }
            break;
        }
        this.ps.ioff = 0;
        this.ps.bufend = this.buf.length();
        int n2 = HttpParser.parseInt(this.buf.getBytes(), 16, this.ps);
        this.eof = n2 == 0;
        return n2;
    }

    public void close() throws IOException {
        this.checkInit();
        if (this.observer != null) {
            this.observer.notifyClose(this);
            this.observer = null;
        }
    }

    public int read() throws IOException {
        this.checkInit();
        if (this.clen == 0) {
            if (this.eof || (this.clen = this.nextChunk(true)) == 0) {
                if (this.observer != null) {
                    this.observer.notifyEOF(this);
                    this.observer = null;
                }
                return -1;
            }
            if (this.isahead) {
                --this.clen;
                this.isahead = false;
                return this.ahead;
            }
        }
        --this.clen;
        return this.in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkInit();
        if (this.eof) {
            if (this.observer != null) {
                this.observer.notifyEOF(this);
                this.observer = null;
            }
            return -1;
        }
        if (this.clen > n2) {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 == -1) {
                this.observer.notifyFailure(this);
                this.observer = null;
                throw new IOException("Chunked stream read aborted (" + this.clen + " remaining in chunk)");
            }
            this.clen -= n3;
            return n3;
        }
        int n4 = 0;
        while (n2 > 0) {
            int n5;
            if (this.clen == 0) {
                if (this.eof || (this.clen = this.nextChunk(true)) == 0) {
                    if (this.observer != null) {
                        this.observer.notifyEOF(this);
                        this.observer = null;
                    }
                    return n4 == 0 ? -1 : n4;
                }
                if (this.isahead) {
                    byArray[n++] = (byte)(this.ahead & 0xFF);
                    --n2;
                    --this.clen;
                    this.isahead = false;
                }
            }
            if ((n5 = this.in.read(byArray, n, Math.min(this.clen, n2))) == -1) {
                this.observer.notifyFailure(this);
                this.observer = null;
                throw new IOException("Chunked stream read aborted");
            }
            n4 += n5;
            n2 -= n5;
            this.clen -= n5;
            n += n5;
        }
        return n4;
    }

    public int available() throws IOException {
        this.checkInit();
        return this.eof ? -1 : 1;
    }

    public long skip(long l) throws IOException {
        this.checkInit();
        byte[] byArray = new byte[512];
        int n = Math.min(byArray.length, (int)l);
        while ((n = this.read(byArray, 0, n)) > 0) {
            l -= (long)n;
            n = Math.min(byArray.length, (int)l);
        }
        return l;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ChunkedInputStream(InputStream inputStream) throws IOException {
        this(null, inputStream);
    }

    public ChunkedInputStream(HttpStreamObserver httpStreamObserver, InputStream inputStream) throws IOException {
        this.observer = httpStreamObserver;
        this.buf = new HttpBuffer();
        this.ps = new ParseState();
        this.in = inputStream;
    }
}

