/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiField;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.utils.RSUtils;
import org.jetbrains.annotations.NotNull;

public class AnnotateElementWithPathParamFix
implements LocalQuickFix {
    private final PsiField myField;
    private final String myName;

    public AnnotateElementWithPathParamFix(PsiField field, String name) {
        this.myField = field;
        this.myName = name;
    }

    @NotNull
    public String getFamilyName() {
        String string = RSBundle.message("annotate.field.with.path.param", this.myName, this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/fixes/AnnotateElementWithPathParamFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/inspections/fixes/AnnotateElementWithPathParamFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ws/rest/inspections/fixes/AnnotateElementWithPathParamFix", "applyFix"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/inspections/fixes/AnnotateElementWithPathParamFix", "lambda$applyFix$0"));
            }
            RSUtils.annotateFieldWithPathParam(project, this.myField, this.myName);
        });
    }
}

