/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.compass.CompassConfigParser;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;
import org.jetbrains.plugins.sass.extensions.compass.CompassUtil;

public abstract class CompassImportPathRegistrationWatcher
implements Disposable {
    public static final Topic<ImportPathsListener> IMPORT_PATHS_CHANGED = Topic.create((String)"compass import paths changed", ImportPathsListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
    protected final Module myModule;
    private static final int QUEUE_UPDATE_TIMEOUT = 5000;
    @Nullable
    private MergingUpdateQueue myQueue;
    @Nullable
    private MessageBusConnection myConnection;
    @NotNull
    private final CompassConfigParser myConfigParser;
    @NotNull
    private final VirtualFileListener myVfsListener;
    @NotNull
    private final PsiTreeChangeAdapter myPsiListener;
    @NotNull
    private final Object mySyncObject;
    private boolean myStarted;

    public CompassImportPathRegistrationWatcher(@NotNull Module module, @NotNull CompassConfigParser configParser) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "<init>"));
        }
        if (configParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configParser", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "<init>"));
        }
        this.mySyncObject = new Object();
        this.myStarted = false;
        this.myModule = module;
        this.myConfigParser = configParser;
        this.myVfsListener = new MyVirtualFileListener();
        this.myPsiListener = new MyPsiTreeChangeAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.mySyncObject;
        synchronized (object) {
            return this.myStarted;
        }
    }

    private boolean isFileToScan(@Nullable VirtualFile file) {
        CompassSettings settings = CompassSettings.getInstance(this.myModule);
        return file != null && settings != null && PathUtil.getFileName((String)settings.getCompassConfigPath()).equals(file.getName()) && FileUtil.pathsEqual((String)settings.getCompassConfigPath(), (String)file.getPath());
    }

    private boolean isEventToScan(@NotNull VirtualFileEvent event) {
        VirtualFile file;
        VirtualFile parent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "isEventToScan"));
        }
        CompassSettings settings = CompassSettings.getInstance(this.myModule);
        if (settings != null && event instanceof VirtualFilePropertyEvent && "name".equals(((VirtualFilePropertyEvent)event).getPropertyName()) && (parent = (file = event.getFile()).getParent()) != null) {
            String configPath = settings.getCompassConfigPath();
            String configFileName = PathUtil.getFileName((String)configPath);
            Object oldName = ((VirtualFilePropertyEvent)event).getOldValue();
            Object newName = ((VirtualFilePropertyEvent)event).getNewValue();
            return (configFileName.equals(oldName) || configFileName.equals(newName)) && FileUtil.pathsEqual((String)PathUtil.getParentPath((String)configPath), (String)parent.getPath());
        }
        return this.isFileToScan(event.getFile());
    }

    @NotNull
    private Collection<VirtualFile> getFilesToScan() {
        String compassConfigPath;
        CompassSettings settings = CompassSettings.getInstance(this.myModule);
        if (settings != null && !(compassConfigPath = settings.getCompassConfigPath()).trim().isEmpty()) {
            VirtualFile configFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)compassConfigPath));
            List list = ContainerUtil.createMaybeSingletonList((Object)configFile);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "getFilesToScan"));
            }
            return list;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "getFilesToScan"));
        }
        return list;
    }

    private void fillWithImportPathsFromConfig(@NotNull Module module, @NotNull VirtualFile file, @NotNull Collection<String> importPaths) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "fillWithImportPathsFromConfig"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "fillWithImportPathsFromConfig"));
        }
        if (importPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPaths", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "fillWithImportPathsFromConfig"));
        }
        importPaths.addAll(this.myConfigParser.parse(file, PsiManager.getInstance((Project)module.getProject())).getImportPaths());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleImportPathsRefresh() {
        Object object = this.mySyncObject;
        synchronized (object) {
            if (this.myQueue != null) {
                this.myQueue.queue((Update)new MyImportPathsScan(this.myModule));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(@NotNull ImportPathsListener importPathsListener, boolean enableFileWatchers) {
        if (importPathsListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPathsListener", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "subscribe"));
        }
        if (this.myModule.isDisposed()) {
            return;
        }
        Object object = this.mySyncObject;
        synchronized (object) {
            if (!this.myStarted) {
                this.myConnection = this.myModule.getProject().getMessageBus().connect((Disposable)this.myModule);
                this.myConnection.subscribe(IMPORT_PATHS_CHANGED, (Object)importPathsListener);
                this.myQueue = new MergingUpdateQueue("CompassImportPathsRegistrationWatcher", 5000, true, null).setRestartTimerOnAdd(true);
                StartupManager.getInstance((Project)this.myModule.getProject()).runWhenProjectIsInitialized(() -> {
                    if (enableFileWatchers) {
                        this.enableWatchers();
                    }
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        ApplicationManager.getApplication().invokeLater((Runnable)((Object)new MyImportPathsScan(this.myModule)));
                    } else {
                        ApplicationManager.getApplication().invokeAndWait((Runnable)((Object)new MyImportPathsScan(this.myModule)), ModalityState.any());
                    }
                });
                this.myStarted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mySyncObject;
        synchronized (object) {
            if (this.myStarted) {
                this.disableWatchers();
                if (this.myConnection != null) {
                    this.myConnection.disconnect();
                    this.myConnection = null;
                }
                if (this.myQueue != null) {
                    this.myQueue.cancelAllUpdates();
                    Disposer.dispose((Disposable)this.myQueue);
                    this.myQueue = null;
                }
                this.myStarted = false;
            }
        }
    }

    private void enableWatchers() {
        PsiManager.getInstance((Project)this.myModule.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiListener);
        VirtualFileManager.getInstance().addVirtualFileListener(this.myVfsListener);
    }

    private void disableWatchers() {
        PsiManager.getInstance((Project)this.myModule.getProject()).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiListener);
        VirtualFileManager.getInstance().removeVirtualFileListener(this.myVfsListener);
    }

    private void doScanImportPaths(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher", "doScanImportPaths"));
        }
        if (module.isDisposed()) {
            return;
        }
        HashSet importPaths = ContainerUtil.newHashSet();
        Collection<VirtualFile> filesToScan = this.getFilesToScan();
        for (VirtualFile file : filesToScan) {
            if (file == null || !file.isValid()) continue;
            this.fillWithImportPathsFromConfig(module, file, importPaths);
            CompassUtil.runCompassImportsAndProcessPaths(module, file, (Processor<String>)new CommonProcessors.CollectProcessor((Collection)importPaths), true);
        }
        if (filesToScan.isEmpty()) {
            CompassUtil.runCompassImportsAndProcessPaths(module, null, (Processor<String>)new CommonProcessors.CollectProcessor((Collection)importPaths), true);
        }
        ((ImportPathsListener)module.getMessageBus().syncPublisher(IMPORT_PATHS_CHANGED)).pathsChanged(module, importPaths);
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyVirtualFileListener", "fileCreated"));
            }
            this.processFileEvent(event);
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyVirtualFileListener", "fileDeleted"));
            }
            this.processFileEvent(event);
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyVirtualFileListener", "propertyChanged"));
            }
            this.processFileEvent((VirtualFileEvent)event);
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyVirtualFileListener", "beforeFileMovement"));
            }
            this.processFileEvent((VirtualFileEvent)event);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyVirtualFileListener", "fileMoved"));
            }
            this.processFileEvent((VirtualFileEvent)event);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyVirtualFileListener", "fileCopied"));
            }
            this.processFileEvent((VirtualFileEvent)event);
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyVirtualFileListener", "contentsChanged"));
            }
            this.processFileEvent(event);
        }

        private void processFileEvent(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyVirtualFileListener", "processFileEvent"));
            }
            if (CompassImportPathRegistrationWatcher.this.isEventToScan(event)) {
                CompassImportPathRegistrationWatcher.this.scheduleImportPathsRefresh();
            }
        }
    }

    private class MyPsiTreeChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeAdapter() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyPsiTreeChangeAdapter", "childAdded"));
            }
            this.processPsiEvent(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyPsiTreeChangeAdapter", "childRemoved"));
            }
            this.processPsiEvent(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyPsiTreeChangeAdapter", "childReplaced"));
            }
            this.processPsiEvent(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyPsiTreeChangeAdapter", "childMoved"));
            }
            this.processPsiEvent(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyPsiTreeChangeAdapter", "childrenChanged"));
            }
            this.processPsiEvent(event);
        }

        private void processPsiEvent(PsiTreeChangeEvent event) {
            PsiFile file = event.getFile();
            if (file != null && CompassImportPathRegistrationWatcher.this.isFileToScan(file.getVirtualFile())) {
                CompassImportPathRegistrationWatcher.this.scheduleImportPathsRefresh();
            }
        }
    }

    private class MyImportPathsScan
    extends Update {
        private final Module myModule;

        public boolean canEat(Update update) {
            return true;
        }

        public MyImportPathsScan(Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyImportPathsScan", "<init>"));
            }
            super((Object)"Compass import paths scan");
            this.myModule = module;
        }

        public void run() {
            if (this.myModule.isDisposed()) {
                return;
            }
            Project project = this.myModule.getProject();
            DumbService.getInstance((Project)project).runWhenSmart(() -> {
                String title = SASSBundle.message("compass.scan.import.paths");
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyImportPathsScan$1", "run"));
                        }
                        if (this.myProject == null || this.myProject.isDisposed()) {
                            return;
                        }
                        CompassImportPathRegistrationWatcher.this.doScanImportPaths(MyImportPathsScan.this.myModule);
                    }
                });
            });
        }
    }

    public static interface ImportPathsListener {
        public void pathsChanged(@NotNull Module var1, @NotNull Set<String> var2);
    }
}

