/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.GroovyMvcIcons;
import java.io.File;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;

public class GrailsLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    public static final LibraryKind GRAILS_KIND = LibraryKind.create((String)"grails");
    private static final Collection<String> ROOT_FOLDER_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"commons", "groovy", "persistence", "scaffolding", "tiger", "web", "java"});

    public GrailsLibraryPresentationProvider() {
        super(GRAILS_KIND);
    }

    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return GrailsConfigUtils.getGrailsLibraryHome(libraryFiles) != null;
    }

    @Nls
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        return GrailsConfigUtils.getGrailsVersion(libraryFiles);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GroovyMvcIcons.Grails_sdk;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsLibraryPresentationProvider", "getIcon"));
        }
        return icon;
    }

    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/config/GrailsLibraryPresentationProvider", "isSDKHome"));
        }
        return GrailsConfigUtils.getInstance().isSDKHome(file);
    }

    @NotNull
    public String getSDKVersion(String path) {
        String string = GrailsConfigUtils.getInstance().getSDKVersion(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsLibraryPresentationProvider", "getSDKVersion"));
        }
        return string;
    }

    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File javadoc;
        File[] jars = new File(path + "/dist").listFiles();
        if (jars != null) {
            for (File file : jars) {
                String fileName = file.getName();
                if (!fileName.endsWith(".jar")) continue;
                OrderRootType orderRootType = fileName.endsWith("-sources.jar") ? OrderRootType.SOURCES : (fileName.endsWith("-javadoc.jar") ? JavadocOrderRootType.getInstance() : OrderRootType.CLASSES);
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), orderRootType);
            }
        }
        GrailsLibraryPresentationProvider.collectJars(new File(path, "lib"), libraryEditor);
        File[] srcFiles = new File(path + "/src").listFiles();
        if (srcFiles != null) {
            for (File srcFile : srcFiles) {
                String name = srcFile.getName();
                if (!(srcFile.isDirectory() ? ROOT_FOLDER_NAMES.contains(name) : name.endsWith("-sources.jar"))) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)srcFile), OrderRootType.SOURCES);
            }
        }
        if ((javadoc = new File(path + "/doc/api")).isDirectory()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)javadoc), JavadocOrderRootType.getInstance());
        }
    }

    private static void collectJars(File path, LibraryEditor libraryEditor) {
        File[] children = path.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                GrailsLibraryPresentationProvider.collectJars(child, libraryEditor);
                continue;
            }
            if (!child.getName().endsWith(".jar") || child.getName().startsWith("javaee-web-api")) continue;
            OrderRootType orderRootType = child.getName().endsWith("-sources.jar") ? OrderRootType.SOURCES : (child.getName().endsWith("-javadoc.jar") ? JavadocOrderRootType.getInstance() : OrderRootType.CLASSES);
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)child), orderRootType);
        }
    }

    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        if ("Grails" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsLibraryPresentationProvider", "getLibraryCategoryName"));
        }
        return "Grails";
    }
}

