/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gradle;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.tests.runner.GrailsUrlProvider;

public class GrailsTestsExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, SMTRunnerConsoleView, ProcessHandler> {
    private static final Logger LOG = Logger.getInstance(GrailsTestsExecutionConsoleManager.class);
    private OutputToGeneralTestEventsConverter outputConsumer;
    private AnAction[] myRestartActions = AnAction.EMPTY_ARRAY;

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "getExternalSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public SMTRunnerConsoleView attachExecutionConsole(@NotNull ExternalSystemTask task, @NotNull Project project, @NotNull ExternalSystemRunConfiguration configuration, @NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "attachExecutionConsole"));
        }
        String testFrameworkName = "GrailsTests";
        GradleConsoleProperties properties = new GradleConsoleProperties(configuration, executor);
        SMTRunnerConsoleView executionConsole = (SMTRunnerConsoleView)SMTestRunnerConnectionUtil.createAndAttachConsole((String)"GrailsTests", (ProcessHandler)processHandler, (TestConsoleProperties)properties);
        GeneralToSMTRunnerEventsConvertor eventsProcessor = new GeneralToSMTRunnerEventsConvertor(project, executionConsole.getResultsViewer().getTestsRootNode(), "GrailsTests");
        this.outputConsumer = new OutputToGeneralTestEventsConverter("GrailsTests", (TestConsoleProperties)properties);
        this.outputConsumer.setProcessor((GeneralTestEventsProcessor)eventsProcessor);
        eventsProcessor.addEventsListener((SMTRunnerEventsListener)executionConsole.getResultsViewer());
        eventsProcessor.setLocator((SMTestLocator)GrailsUrlProvider.INSTANCE);
        SMTRunnerConsoleView sMTRunnerConsoleView = executionConsole;
        if (sMTRunnerConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "attachExecutionConsole"));
        }
        return sMTRunnerConsoleView;
    }

    public void onOutput(@NotNull SMTRunnerConsoleView executionConsole, @NotNull ProcessHandler processHandler, @NotNull String text, @NotNull Key processOutputType) {
        if (executionConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionConsole", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "onOutput"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "onOutput"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "onOutput"));
        }
        if (processOutputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutputType", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "onOutput"));
        }
        if (text.startsWith("##teamcity")) {
            this.outputConsumer.process(text, processOutputType);
        } else {
            executionConsole.print(text, ConsoleViewContentType.getConsoleViewType((Key)processOutputType));
            int i = text.indexOf(" - view reports in ");
            if (i != -1) {
                GradleConsoleProperties gradleConsoleProperties = (GradleConsoleProperties)executionConsole.getProperties();
                String reportPath = text.substring(i + " - view reports in ".length()).trim() + "/html/index.html";
                gradleConsoleProperties.setGradleTestReport(new File(reportPath));
            }
        }
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "isApplicableFor"));
        }
        if (task instanceof ExternalSystemExecuteTaskTask) {
            ExternalSystemExecuteTaskTask taskTask = (ExternalSystemExecuteTaskTask)task;
            if (!StringUtil.equals((CharSequence)taskTask.getExternalSystemId().getId(), (CharSequence)GradleConstants.SYSTEM_ID.getId())) {
                return false;
            }
            return ContainerUtil.find((Iterable)taskTask.getTasksToExecute(), taskName -> "grails-test-app".equals(taskName)) != null;
        }
        return false;
    }

    public AnAction[] getRestartActions(@NotNull SMTRunnerConsoleView consoleView) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "org/jetbrains/plugins/grails/gradle/GrailsTestsExecutionConsoleManager", "getRestartActions"));
        }
        return this.myRestartActions;
    }
}

