/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.taglib;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;

public class TaglibClosureParamEnhancer
extends AbstractClosureParameterEnhancer {
    protected PsiType getClosureParameterType(GrClosableBlock closure, int index) {
        if (TaglibClosureParamEnhancer.isTaglibClosure(closure)) {
            if (index == 0) {
                return JavaPsiFacade.getElementFactory((Project)closure.getProject()).createTypeByFQClassName("java.util.Map", closure.getResolveScope());
            }
            if (index == 1) {
                return JavaPsiFacade.getElementFactory((Project)closure.getProject()).createTypeByFQClassName("groovy.lang.Closure", closure.getResolveScope());
            }
        }
        return null;
    }

    private static boolean isTaglibClosure(GrClosableBlock closure) {
        PsiElement parent = closure.getParent();
        if (!(parent instanceof GrField)) {
            return false;
        }
        GrField field = (GrField)parent;
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (className == null || !className.endsWith(GrailsArtifact.TAGLIB.suffix)) {
            return false;
        }
        if (className.startsWith("org.codehaus.groovy.grails.plugins.web.taglib")) {
            return true;
        }
        return GrailsArtifact.TAGLIB.isInstance(aClass);
    }
}

