/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection.annotation;

import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.reflection.annotation.AnnotationAnalyzer;
import android.databinding.tool.reflection.annotation.AnnotationMethod;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;

public class AnnotationTypeUtil
extends TypeUtil {
    Types mTypes;

    public AnnotationTypeUtil(AnnotationAnalyzer annotationAnalyzer) {
        this.mTypes = annotationAnalyzer.getTypeUtils();
    }

    public static AnnotationTypeUtil getInstance() {
        return (AnnotationTypeUtil)TypeUtil.getInstance();
    }

    @Override
    public String getDescription(ModelClass modelClass) {
        return modelClass.getCanonicalName().replace('.', '/');
    }

    @Override
    public String getDescription(ModelMethod modelMethod) {
        AnnotationMethod method = (AnnotationMethod)modelMethod;
        return this.getExecutableDescription(method.mExecutableElement, method.mMethod);
    }

    private String getDescription(TypeMirror typeMirror) {
        if (typeMirror == null) {
            throw new UnsupportedOperationException();
        }
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                return "Z";
            }
            case BYTE: {
                return "B";
            }
            case SHORT: {
                return "S";
            }
            case INT: {
                return "I";
            }
            case LONG: {
                return "J";
            }
            case CHAR: {
                return "C";
            }
            case FLOAT: {
                return "F";
            }
            case DOUBLE: {
                return "D";
            }
            case DECLARED: {
                return "L" + this.toJava(this.mTypes.erasure(typeMirror)).replace('.', '/') + ";";
            }
            case VOID: {
                return "V";
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                String componentType = this.getDescription(arrayType.getComponentType());
                return "[" + componentType;
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                String name = this.toJava(typeVariable);
                return "L" + name.replace('.', '/') + ";";
            }
            case EXECUTABLE: {
                return this.getExecutableDescription((ExecutableElement)this.mTypes.asElement(typeMirror), (ExecutableType)typeMirror);
            }
        }
        throw new UnsupportedOperationException("cannot understand type " + typeMirror.toString() + ", kind:" + typeMirror.getKind().name());
    }

    private String getExecutableDescription(ExecutableElement executableElement, ExecutableType executableType) {
        String methodName = executableElement.getSimpleName().toString();
        String args = executableType.getParameterTypes().stream().map(arg -> this.getDescription((TypeMirror)arg)).collect(Collectors.joining("", "(", ")"));
        return methodName + args + this.getDescription(executableType.getReturnType());
    }

    public String toJava(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case SHORT: {
                return "short";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case CHAR: {
                return "char";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case VOID: {
                return "void";
            }
            case NULL: {
                return "null";
            }
            case ARRAY: {
                return this.toJava((ArrayType)typeMirror);
            }
            case DECLARED: {
                return this.toJava((DeclaredType)typeMirror);
            }
            case TYPEVAR: {
                return this.toJava((TypeVariable)typeMirror);
            }
            case WILDCARD: {
                return this.toJava((WildcardType)typeMirror);
            }
            case NONE: 
            case PACKAGE: {
                return this.toJava(this.mTypes.asElement(typeMirror));
            }
            case EXECUTABLE: {
                return this.toJava((ExecutableType)typeMirror);
            }
            case UNION: {
                return this.toJava((UnionType)typeMirror);
            }
            case INTERSECTION: {
                return this.toJava((IntersectionType)typeMirror);
            }
            case ERROR: {
                return this.mTypes.asElement(typeMirror).getSimpleName().toString();
            }
        }
        throw new IllegalArgumentException("Unexpected TypeMirror kind " + (Object)((Object)typeMirror.getKind()) + ": " + typeMirror);
    }

    private String toJava(ArrayType arrayType) {
        TypeMirror component = arrayType.getComponentType();
        return this.toJava(component) + "[]";
    }

    private String toJava(DeclaredType declaredType) {
        TypeMirror enclosingType = declaredType.getEnclosingType();
        StringBuilder sb = new StringBuilder();
        if (enclosingType.getKind() != TypeKind.NONE) {
            sb.append(this.toJava(enclosingType)).append(".").append(declaredType.asElement().getSimpleName());
        } else {
            sb.append(this.toJava(declaredType.asElement()));
        }
        List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
        if (typeArgs != null && !typeArgs.isEmpty()) {
            String typeArgsString = typeArgs.stream().map(typeArg -> this.toJava((TypeMirror)typeArg)).collect(Collectors.joining(",", "<", ">"));
            sb.append(typeArgsString);
        }
        return sb.toString();
    }

    private String toJava(WildcardType wildcardType) {
        TypeMirror superBound;
        StringBuilder sb = new StringBuilder("?");
        TypeMirror extendsBound = wildcardType.getExtendsBound();
        if (extendsBound != null) {
            sb.append(" extends ").append(this.toJava(extendsBound));
        }
        if ((superBound = wildcardType.getSuperBound()) != null) {
            sb.append(" super ").append(this.toJava(superBound));
        }
        return sb.toString();
    }

    private String toJava(ExecutableType executableType) {
        return this.toJava((ExecutableElement)this.mTypes.asElement(executableType), executableType);
    }

    public String toJava(ExecutableElement executableElement, ExecutableType executableType) {
        ElementKind kind;
        List<? extends TypeVariable> typeVariables;
        StringBuilder sb = new StringBuilder();
        if (executableElement.getModifiers() != null) {
            sb.append(executableElement.getModifiers().stream().map(mod -> mod.toString()).collect(Collectors.joining(" ", "", " ")));
        }
        if ((typeVariables = executableType.getTypeVariables()) != null && !typeVariables.isEmpty()) {
            String typeVariablesString = typeVariables.stream().map(typeVar -> this.toJava((TypeVariable)typeVar)).collect(Collectors.joining(",", "<", "> "));
            sb.append(typeVariablesString);
        }
        if ((kind = executableElement.getKind()) == ElementKind.METHOD) {
            sb.append(this.toJava(executableType.getReturnType()));
            sb.append(' ');
        }
        sb.append(executableElement.getSimpleName().toString());
        List<? extends TypeMirror> paramTypes = executableType.getParameterTypes();
        if (paramTypes == null) {
            sb.append("()");
        } else {
            String params = executableType.getParameterTypes().stream().map(paramType -> this.toJava((TypeMirror)paramType)).collect(Collectors.joining(",", "(", ")"));
            sb.append(params);
        }
        return sb.toString();
    }

    private String toJava(TypeVariable typeVariable) {
        TypeMirror lowerBound;
        StringBuilder sb = new StringBuilder(typeVariable.asElement().getSimpleName().toString());
        TypeMirror upperBound = typeVariable.getUpperBound();
        String upperBoundString = this.toJava(upperBound);
        if (!"java.lang.Object".equals(upperBoundString)) {
            sb.append(" extends ").append(upperBoundString);
        }
        if ((lowerBound = typeVariable.getLowerBound()).getKind() != TypeKind.NULL) {
            sb.append(" super ").append(this.toJava(lowerBound));
        }
        return sb.toString();
    }

    private String toJava(UnionType unionType) {
        return unionType.getAlternatives().stream().map(alt -> this.toJava((TypeMirror)alt)).collect(Collectors.joining(" | "));
    }

    private String toJava(IntersectionType intersectionType) {
        return intersectionType.getBounds().stream().map(bounds -> this.toJava((TypeMirror)bounds)).collect(Collectors.joining(" & "));
    }

    private String toJava(Element element) {
        Element enclosing = element.getEnclosingElement();
        if (enclosing != null) {
            switch (enclosing.getKind()) {
                case PACKAGE: {
                    return ((PackageElement)enclosing).getQualifiedName().toString() + '.' + element.getSimpleName().toString();
                }
                case ENUM: 
                case CLASS: 
                case INTERFACE: 
                case ENUM_CONSTANT: 
                case FIELD: {
                    return this.toJava(enclosing) + '.' + element.getSimpleName();
                }
            }
        }
        return element.getSimpleName().toString();
    }
}

