/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectName
implements Comparable<ObjectName> {
    public static final ObjectName[] EMPTY_ARRAY = new ObjectName[0];
    public final String name;
    public final boolean quoted;
    private Integer myInsensitiveHash;

    public static ObjectName quoted(@Nullable String name) {
        return name == null ? null : new ObjectName(name, true);
    }

    public static ObjectName plain(@Nullable String name) {
        return name == null ? null : new ObjectName(name, false);
    }

    public ObjectName(@NotNull String name, boolean quoted) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/ObjectName", "<init>"));
        }
        this.myInsensitiveHash = null;
        this.name = name;
        this.quoted = quoted;
    }

    public static boolean equals(@Nullable ObjectName a, @Nullable ObjectName b, @NotNull Casing casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/model/ObjectName", "equals"));
        }
        return a == null || b == null ? a == b : a.equals(b, casing);
    }

    public boolean equals(@NotNull ObjectName other, @NotNull Casing casing) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/model/ObjectName", "equals"));
        }
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/model/ObjectName", "equals"));
        }
        if (this == other) {
            return true;
        }
        if (this.hashCode(casing) != other.hashCode(casing)) {
            return false;
        }
        Case case1 = this.getCase(casing);
        Case case2 = other.getCase(casing);
        if (case1 == Case.MIXED || case2 == Case.MIXED) {
            return StringUtil.equalsIgnoreCase((CharSequence)this.name, (CharSequence)other.name);
        }
        return case1.apply(this.name).equals(case2.apply(other.name));
    }

    @NotNull
    private Case getCase(@NotNull Casing casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/model/ObjectName", "getCase"));
        }
        Case case_ = casing.choose(!this.quoted);
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ObjectName", "getCase"));
        }
        return case_;
    }

    public int hashCode(@NotNull Casing casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/model/ObjectName", "hashCode"));
        }
        if (casing.plain == Case.EXACT && casing.quoted == Case.EXACT) {
            return this.name.hashCode();
        }
        if (this.myInsensitiveHash == null) {
            this.myInsensitiveHash = StringUtil.stringHashCodeInsensitive((CharSequence)this.name);
        }
        return this.myInsensitiveHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectName name1 = (ObjectName)o;
        if (this.quoted != name1.quoted) {
            return false;
        }
        return this.name.equals(name1.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.quoted ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.quoted ? "`" + this.name.replace("`", "``") + "`" : this.name;
    }

    @NotNull
    public static ObjectName[] toArray(@NotNull Iterable<ObjectName> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/model/ObjectName", "toArray"));
        }
        Collection collection = items instanceof Collection ? (Collection)items : ContainerUtil.collect(items.iterator());
        ObjectName[] objectNameArray = collection.isEmpty() ? EMPTY_ARRAY : collection.toArray(new ObjectName[collection.size()]);
        if (objectNameArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ObjectName", "toArray"));
        }
        return objectNameArray;
    }

    @Override
    public int compareTo(@NotNull ObjectName o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/model/ObjectName", "compareTo"));
        }
        int res = Comparing.compare((Comparable)((Object)this.name), (Comparable)((Object)o.name));
        return res != 0 ? res : Comparing.compare((boolean)this.quoted, (boolean)o.quoted);
    }

    public static class HashingStrategy
    implements TObjectHashingStrategy<ObjectName> {
        private final Casing myCasing;

        public HashingStrategy(@NotNull Casing casing) {
            if (casing == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/model/ObjectName$HashingStrategy", "<init>"));
            }
            this.myCasing = casing;
        }

        public int computeHashCode(ObjectName object) {
            return object.hashCode(this.myCasing);
        }

        public boolean equals(ObjectName o1, ObjectName o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            return o1.equals(o2, this.myCasing);
        }
    }
}

