/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.sql.psi.SqlPrimitiveType;

public abstract class SqlType {
    public static final SqlPrimitiveType UNKNOWN = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "unknown";
        }
    };
    public static final SqlPrimitiveType DEFAULT = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "default";
        }
    };
    public static final SqlPrimitiveType INTEGER = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "number";
        }
    };
    public static final SqlPrimitiveType REAL = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "float";
        }
    };
    public static final SqlPrimitiveType STRING = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "string";
        }
    };
    public static final SqlPrimitiveType BOOLEAN = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "boolean";
        }
    };
    public static final SqlPrimitiveType DATE_TIME = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "datetime";
        }
    };
    public static final SqlPrimitiveType DATE = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "date";
        }
    };
    public static final SqlPrimitiveType TIME = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "time";
        }
    };
    public static final SqlPrimitiveType TIMESTAMP = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "timestamp";
        }
    };
    public static final SqlPrimitiveType INTERVAL = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "interval";
        }
    };
    public static final SqlPrimitiveType BYTES = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "bytes";
        }
    };
    public static final SqlPrimitiveType REFERENCE = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "reference";
        }
    };
    public static final SqlPrimitiveType ARRAY = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "array";
        }
    };
    public static final SqlPrimitiveType COLLECTION = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "collection";
        }
    };
    public static final SqlPrimitiveType RECORD = new SqlPrimitiveType(){

        @Override
        public String getDisplayName() {
            return "record";
        }
    };

    public abstract boolean isPrimitive();

    public abstract String getDisplayName();

    public static SqlPrimitiveType findByJdbcType(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case -5: 
            case 1: 
            case 4: 
            case 5: {
                return INTEGER;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return REAL;
            }
            case -1: 
            case 12: 
            case 2005: {
                return STRING;
            }
            case 91: {
                return DATE;
            }
            case 92: {
                return TIME;
            }
            case 93: {
                return TIMESTAMP;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2000: 
            case 2004: {
                return BYTES;
            }
            case 2003: {
                return ARRAY;
            }
            case 16: {
                return BOOLEAN;
            }
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

