/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Function;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentialException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.VagrantSupport;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CaseCollector;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkCredentialsProducerImpl<T extends RemoteSdkCredentials>
implements RemoteSdkCredentialsProducer<T> {
    @NotNull
    private final Function<RemoteCredentials, T> myTransformer;
    @NotNull
    private final RemoteConnectionCredentialsWrapper myWrapper;

    public RemoteSdkCredentialsProducerImpl(@NotNull Function<RemoteCredentials, T> transformer, @NotNull RemoteConnectionCredentialsWrapper wrapper) {
        if (transformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformer", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "<init>"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "<init>"));
        }
        this(transformer, wrapper, false);
    }

    public RemoteSdkCredentialsProducerImpl(@NotNull Function<RemoteCredentials, T> transformer, @NotNull RemoteConnectionCredentialsWrapper wrapper, boolean useCache) {
        if (transformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformer", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "<init>"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "<init>"));
        }
        this.myTransformer = transformer;
        this.myWrapper = wrapper;
    }

    public void produceRemoteSdkCredentials(final @Nullable Project project, final boolean allowSynchronousInteraction, final @NotNull Consumer<T> remoteSdkCredentialsConsumer) {
        if (remoteSdkCredentialsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteSdkCredentialsConsumer", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "produceRemoteSdkCredentials"));
        }
        this.myWrapper.switchType(new CaseCollector(){

            protected void processWithType(CredentialsTypeEx typeEx, Object credentials) {
                remoteSdkCredentialsConsumer.consume(RemoteSdkCredentialsProducerImpl.this.myTransformer.apply((Object)typeEx.createRemoteCredentials(credentials)));
            }
        }.collectCases(new CredentialsCase[]{new CredentialsCase.Ssh(){

            public void process(RemoteCredentialsHolder cred) {
                remoteSdkCredentialsConsumer.consume(RemoteSdkCredentialsProducerImpl.this.myTransformer.apply((Object)cred));
            }
        }, new CredentialsCase.Vagrant(){

            public void process(VagrantBasedCredentialsHolder cred) {
                RemoteCredentials credentials = RemoteSdkCredentialsProducerImpl.getAndCheckVagrantRemoteCredentials(cred, allowSynchronousInteraction);
                remoteSdkCredentialsConsumer.consume(RemoteSdkCredentialsProducerImpl.this.myTransformer.apply((Object)credentials));
            }
        }, new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder cred) {
                String webServerConfigId = cred.getWebServerConfigId();
                if (webServerConfigId == null) {
                    throw new RemoteCredentialException("Deployment server is not configured");
                }
                RemoteCredentials sshCredentials = RemoteSdkCredentialsProducerImpl.getCredentialsBySftpServerId(project, webServerConfigId);
                if (sshCredentials == null) {
                    throw new RemoteCredentialException("Can't get remote credentials for deployment server " + cred.getWebServerConfigName());
                }
                remoteSdkCredentialsConsumer.consume(RemoteSdkCredentialsProducerImpl.this.myTransformer.apply((Object)sshCredentials));
            }
        }}));
    }

    @NotNull
    private static RemoteCredentials getAndCheckVagrantRemoteCredentials(@NotNull VagrantBasedCredentialsHolder cred, boolean allowSynchronousInteraction) {
        RemoteCredentials remoteCredentials;
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "getAndCheckVagrantRemoteCredentials"));
        }
        if (StringUtil.isEmpty((String)cred.getVagrantFolder())) {
            throw new IllegalStateException("Vagrant instance folder is not specified");
        }
        try {
            RemoteCredentials credentials = RemoteSdkCredentialsProducerImpl.getVagrantRemoteCredentials(cred);
            if (credentials == null) {
                throw new RemoteCredentialException("Cant obtain ssh credentials for Vagrant at " + cred.getVagrantFolder());
            }
            if (!RemoteSdkUtil.testConnection(null, credentials) && !RemoteSdkCredentialsProducerImpl.checkVagrantStatus(cred.getVagrantFolder(), cred.getMachineName(), allowSynchronousInteraction)) {
                throw new VagrantNotStartedException("Vagrant VM" + (cred.getMachineName() != null ? " '" + cred.getMachineName() + "'" : "") + " at " + cred.getVagrantFolder() + " is not launched", cred.getVagrantFolder(), cred.getMachineName());
            }
            remoteCredentials = credentials;
        }
        catch (IOException e) {
            throw new VagrantNotStartedException(e.getMessage(), cred.getVagrantFolder(), cred.getMachineName());
        }
        if (remoteCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "getAndCheckVagrantRemoteCredentials"));
        }
        return remoteCredentials;
    }

    public void produceRemoteSdkCredentials(boolean allowSynchronousInteraction, @NotNull Consumer<T> remoteSdkCredentialsConsumer) {
        if (remoteSdkCredentialsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteSdkCredentialsConsumer", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "produceRemoteSdkCredentials"));
        }
        this.produceRemoteSdkCredentials(null, allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(@NotNull Consumer<T> remoteSdkCredentialsConsumer) {
        if (remoteSdkCredentialsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteSdkCredentialsConsumer", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "produceRemoteSdkCredentials"));
        }
        this.produceRemoteSdkCredentials(null, true, remoteSdkCredentialsConsumer);
    }

    @Deprecated
    public T getRemoteSdkCredentials() throws InterruptedException, ExecutionException {
        return this.getRemoteSdkCredentials(null, true);
    }

    public T getRemoteSdkCredentials(boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return this.getRemoteSdkCredentials(null, allowSynchronousInteraction);
    }

    public T getRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        MyRemoteCredentialsConsumer c = new MyRemoteCredentialsConsumer();
        try {
            this.produceRemoteSdkCredentials(project, allowSynchronousInteraction, c);
        }
        catch (RuntimeException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        c.await();
        return (T)c.myRemoteSdkCredentials;
    }

    public Object getRemoteSdkDataKey() {
        return this.myWrapper.getConnectionKey();
    }

    @Nullable
    private static RemoteCredentials getVagrantRemoteCredentials(@NotNull VagrantBasedCredentialsHolder data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "getVagrantRemoteCredentials"));
        }
        VagrantSupport vs = VagrantSupport.getInstance();
        if (vs != null) {
            return vs.getCredentials(data.getVagrantFolder(), data.getMachineName());
        }
        VagrantSupport.showMissingVagrantSupportMessage(null);
        return null;
    }

    private static boolean checkVagrantStatus(@NotNull String vagrantFolder, @Nullable String machineName, boolean askToRunIfDown) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "checkVagrantStatus"));
        }
        VagrantSupport vs = VagrantSupport.getInstance();
        if (vs != null) {
            return vs.checkVagrantRunning(vagrantFolder, machineName, askToRunIfDown);
        }
        throw new IllegalStateException("Vagrant Support unavailable");
    }

    @Nullable
    public static RemoteCredentials getCredentialsBySftpServerId(@Nullable Project project, @Nullable String id) {
        WebServerConfig server = WebServersConfigManager.getInstance((Project)project).findServer(id, true);
        if (server != null && server.getFileTransferConfig().getAccessType() == AccessType.SFTP) {
            return WebDeploymentCredentialHelper.getRemoteCredentials((WebServerConfig)server);
        }
        return null;
    }

    private class MyRemoteCredentialsConsumer
    implements Consumer<T> {
        private final CountDownLatch myLatch = new CountDownLatch(1);
        private T myRemoteSdkCredentials;

        private MyRemoteCredentialsConsumer() {
        }

        public void consume(T data) {
            this.myRemoteSdkCredentials = data;
            this.myLatch.countDown();
        }

        public void await() throws InterruptedException {
            this.myLatch.await();
        }
    }
}

