/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.jetbrains.plugins.remotesdk.RemoteSdkUsagesProvider;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkTypeCountUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final GroupDescriptor GROUP_ID = GroupDescriptor.create((String)"remote-sdk-types-count");

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GROUP_ID;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeCountUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeCountUsagesCollector", "getProjectUsages"));
        }
        Set<UsageDescriptor> set = !project.isDefault() ? this.collectUsages(project) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeCountUsagesCollector", "getProjectUsages"));
        }
        return set;
    }

    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        Set set = RemoteSdkTypeCountUsagesCollector.merge((Set)super.getUsages(), this.collectUsages(null));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeCountUsagesCollector", "getUsages"));
        }
        return set;
    }

    @NotNull
    public Set<UsageDescriptor> collectUsages(@Nullable Project project) {
        RemoteSdkUsagesProvider[] providers;
        THashSet usages = new THashSet();
        for (RemoteSdkUsagesProvider provider : providers = RemoteSdkUsagesProvider.getInstances()) {
            int count = (int)provider.getRemoteSdks(project).stream().map(sdk -> sdk.getRemoteConnectionType()).distinct().count();
            usages.add(new UsageDescriptor(provider.getPresentableName() + " " + count, 1));
        }
        THashSet tHashSet = usages;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeCountUsagesCollector", "collectUsages"));
        }
        return tHashSet;
    }
}

