/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.jetbrains.plugins.remotesdk.RemoteSdkUsagesProvider;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkTypeUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final GroupDescriptor GROUP_ID = GroupDescriptor.create((String)"remote-sdk-types");

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GROUP_ID;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector", "getProjectUsages"));
        }
        Set<UsageDescriptor> set = !project.isDefault() ? this.collectUsages(project) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector", "getProjectUsages"));
        }
        return set;
    }

    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        Set set = RemoteSdkTypeUsagesCollector.merge((Set)super.getUsages(), this.collectUsages(null));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector", "getUsages"));
        }
        return set;
    }

    @NotNull
    public Set<UsageDescriptor> collectUsages(@Nullable Project project) {
        RemoteSdkUsagesProvider[] providers;
        THashSet usages = new THashSet();
        for (RemoteSdkUsagesProvider provider : providers = RemoteSdkUsagesProvider.getInstances()) {
            Map collected = provider.getRemoteSdks(project).stream().map(sdk -> sdk.getRemoteConnectionType()).collect(Collectors.groupingBy(type -> type, MoreCollectors.countingInt()));
            String name = provider.getPresentableName();
            for (Map.Entry entry : collected.entrySet()) {
                usages.add(new UsageDescriptor(name + " " + entry.getKey().getName(), ((Integer)entry.getValue()).intValue()));
            }
        }
        THashSet tHashSet = usages;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector", "collectUsages"));
        }
        return tHashSet;
    }
}

