/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsBuilder;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolProcessAdapter;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.tools.RemoteTool;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionManager;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RemoteToolRunProfile
implements ModuleRunProfile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tools.ToolRunProfile");
    private final RemoteTool myTool;
    private RemoteCredentials myRemoteCredentials;
    private final DataContext myContext;
    private final GeneralCommandLine myCommandLine;

    public RemoteToolRunProfile(RemoteTool tool, RemoteCredentials remoteCredentials, DataContext context) {
        this.myTool = tool;
        this.myRemoteCredentials = remoteCredentials;
        this.myContext = context;
        this.myCommandLine = this.myTool.createCommandLine(context);
    }

    public String getName() {
        return RemoteToolRunProfile.expandMacrosInName(this.myTool, this.myContext);
    }

    public static String expandMacrosInName(Tool tool, DataContext context) {
        String name = tool.getName();
        try {
            return MacroManager.getInstance().expandMacrosInString(name, true, context);
        }
        catch (Macro.ExecutionCancelledException e) {
            LOG.info((Throwable)e);
            return name;
        }
    }

    public Icon getIcon() {
        return null;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        FilterInfo[] outputFilters;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile", "getState"));
        }
        final Project project = env.getProject();
        if (project == null || this.myCommandLine == null) {
            return null;
        }
        CommandLineState commandLineState = new CommandLineState(env){

            GeneralCommandLine createCommandLine() {
                return RemoteToolRunProfile.this.myCommandLine;
            }

            @NotNull
            protected ProcessHandler startProcess() throws ExecutionException {
                GeneralCommandLine commandLine = this.createCommandLine();
                SshRemoteSession runProcessSession = SshConnectionManager.getInstance().getSession(project, RemoteToolRunProfile.this.myRemoteCredentials);
                RemoteSdkCredentials sdkData = new RemoteSdkCredentialsBuilder().withCredentials(RemoteToolRunProfile.this.myRemoteCredentials).withInterpreterPath("").build();
                JschProcess process = RemoteSdkUtil.createRemoteProcess(runProcessSession, commandLine, true, false, true);
                ColoredRemoteProcessHandler processHandler = new ColoredRemoteProcessHandler((RemoteProcess)process, commandLine.getCommandLineString(sdkData.getFullInterpreterPath() + ":" + commandLine.getExePath()), EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
                ColoredRemoteProcessHandler coloredRemoteProcessHandler = processHandler;
                if (coloredRemoteProcessHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1", "startProcess"));
                }
                return coloredRemoteProcessHandler;
            }

            @NotNull
            public ExecutionResult execute(final @NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1", "execute"));
                }
                if (runner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1", "execute"));
                }
                ExecutionResult result = super.execute(executor, runner);
                final ProcessHandler processHandler = result.getProcessHandler();
                if (processHandler != null) {
                    processHandler.addProcessListener((ProcessListener)new ToolProcessAdapter(project, RemoteToolRunProfile.this.myTool.synchronizeAfterExecution(), RemoteToolRunProfile.this.getName()));
                    processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(ProcessEvent event, Key outputType) {
                            if (outputType == ProcessOutputTypes.STDOUT && RemoteToolRunProfile.this.myTool.isShowConsoleOnStdOut() || outputType == ProcessOutputTypes.STDERR && RemoteToolRunProfile.this.myTool.isShowConsoleOnStdErr()) {
                                ExecutionManager.getInstance((Project)project).getContentManager().toFrontRunContent(executor, processHandler);
                            }
                        }
                    });
                }
                ExecutionResult executionResult = result;
                if (executionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1", "execute"));
                }
                return executionResult;
            }
        };
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        for (FilterInfo outputFilter : outputFilters = this.myTool.getOutputFilters()) {
            builder.addFilter((Filter)new RegexpFilter(project, outputFilter.getRegExp()));
        }
        commandLineState.setConsoleBuilder(builder);
        return commandLineState;
    }
}

