/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import com.jetbrains.plugins.webDeployment.transport.SessionConfig;
import com.jetbrains.plugins.webDeployment.transport.SshConnectionService;
import com.jetbrains.plugins.webDeployment.transport.SshConnectionUtil;
import com.jetbrains.plugins.webDeployment.transport.SshSessionKey;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugins/remotesdk/transport/SshConnectionServiceUtil;", "", "()V", "getIdentities", "", "Lorg/apache/commons/vfs2/provider/sftp/IdentityInfo;", "data", "Lcom/intellij/remote/RemoteCredentials;", "(Lcom/intellij/remote/RemoteCredentials;)[Lorg/apache/commons/vfs2/provider/sftp/IdentityInfo;", "remoteCredentialsToSessionConfig", "Lcom/jetbrains/plugins/webDeployment/transport/SessionConfig;", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "userInfo", "Lcom/jcraft/jsch/UserInfo;", "remoteCredentialsToSessionKey", "Lcom/jetbrains/plugins/webDeployment/transport/SshSessionKey;", "remote-run"})
public final class SshConnectionServiceUtil {
    public static final SshConnectionServiceUtil INSTANCE;

    @Nullable
    public final IdentityInfo[] getIdentities(@NotNull RemoteCredentials data) {
        String privateKeyFile;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)data.getAuthType(), (Object)AuthType.KEY_PAIR) && (privateKeyFile = data.getPrivateKeyFile()) != null) {
            byte[] byArray;
            CharSequence charSequence = data.getPassphrase();
            if (charSequence == null || charSequence.length() == 0) {
                byArray = null;
            } else {
                charSequence = data.getPassphrase();
                Charset charset = Charsets.UTF_8;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = ((String)charSequence2).getBytes(charset);
                byArray = byArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            }
            byte[] passphrase = byArray;
            Object[] elements$iv = new IdentityInfo[]{new IdentityInfo(new File(privateKeyFile), passphrase)};
            return (IdentityInfo[])elements$iv;
        }
        return null;
    }

    @NotNull
    public final SshSessionKey remoteCredentialsToSessionKey(@NotNull RemoteCredentials data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = data.getUserName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"data.userName");
        String string2 = data.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.host");
        return new SshSessionKey(string, string2, data.getPort(), data.getPassword(), this.getIdentities(data), SshConnectionService.Companion.getInstance().getIdentityRepositoryFactory(data));
    }

    @NotNull
    public final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable UserInfo userInfo) {
        IdentityInfo[] identities;
        Comparable<Charset> comparable;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        int timeoutInMillis = SshConnectionUtil.INSTANCE.toTimeoutInMillis(timeout, timeUnit);
        String knownHosts = data.getKnownHostsFile();
        File knownHostsFile = null;
        if (knownHosts != null) {
            knownHostsFile = new File(knownHosts);
        } else {
            File knownHostsFileCandidate = new File(SftpClientFactory.findSshDir(), "known_hosts");
            if (knownHostsFileCandidate.isFile() && knownHostsFileCandidate.canRead()) {
                knownHostsFile = knownHostsFileCandidate;
            }
        }
        JSch.setConfig((String)"HashKnownHosts", (String)"no");
        if (Intrinsics.areEqual((Object)data.getAuthType(), (Object)AuthType.KEY_PAIR)) {
            byte[] byArray;
            IdentityInfo identityInfo;
            IdentityInfo[] identityInfoArray = new IdentityInfo[1];
            IdentityInfo[] identityInfoArray2 = identityInfoArray;
            IdentityInfo[] identityInfoArray3 = identityInfoArray;
            int n = 0;
            IdentityInfo identityInfo2 = identityInfo;
            IdentityInfo identityInfo3 = identityInfo;
            File file = new File(data.getPrivateKeyFile());
            String string2 = data.getPassphrase();
            if (string2 != null) {
                string = string2;
                File file2 = file;
                IdentityInfo identityInfo4 = identityInfo2;
                IdentityInfo identityInfo5 = identityInfo3;
                int n2 = n;
                IdentityInfo[] identityInfoArray4 = identityInfoArray2;
                IdentityInfo[] identityInfoArray5 = identityInfoArray3;
                comparable = Charsets.UTF_8;
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = string3.getBytes((Charset)comparable);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray3 = byArray2;
                identityInfoArray3 = identityInfoArray5;
                identityInfoArray2 = identityInfoArray4;
                n = n2;
                identityInfo3 = identityInfo5;
                identityInfo2 = identityInfo4;
                file = file2;
                byArray = byArray3;
            } else {
                byArray = null;
            }
            identityInfo2(file, byArray);
            identityInfoArray2[n] = identityInfo3;
            Object[] elements$iv = identityInfoArray3;
            identities = (IdentityInfo[])elements$iv;
        } else {
            identities = null;
        }
        String string4 = data.getUserName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"data.userName");
        String string5 = data.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"data.host");
        string = null;
        comparable = knownHostsFile;
        IdentityRepositoryFactory identityRepositoryFactory = SshConnectionService.Companion.getInstance().getIdentityRepositoryFactory(data);
        IdentityInfo[] identityInfoArray = identities;
        boolean bl = false;
        Integer n = null;
        Integer n3 = null;
        SocketFactory socketFactory = null;
        Proxy proxy = null;
        UserInfo userInfo2 = userInfo;
        Properties properties = SshConnectionUtil.INSTANCE.createConfig();
        Integer n4 = timeoutInMillis;
        return new SessionConfig(string4, string5, data.getPort(), null, properties, n4, userInfo2, proxy, socketFactory, n3, n, bl, (File)comparable, identityInfoArray, identityRepositoryFactory, (File)((Object)string), 36744, null);
    }

    private SshConnectionServiceUtil() {
        INSTANCE = this;
    }

    static {
        new SshConnectionServiceUtil();
    }
}

