/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ConsoleMessage;
import com.intellij.javascript.debugger.ConsoleMessageBuilder;
import com.jetbrains.debugger.wip.WipConsoleAPICalledKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.ExceptionDetailsValue;
import org.jetbrains.wip.protocol.runtime.ExceptionThrownEventData;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/debugger/wip/WipExceptionThrown;", "Lcom/intellij/javascript/debugger/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/runtime/ExceptionThrownEventData;", "(Lorg/jetbrains/wip/protocol/runtime/ExceptionThrownEventData;)V", "getMessage", "()Lorg/jetbrains/wip/protocol/runtime/ExceptionThrownEventData;", "print", "", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "printer", "Lcom/intellij/javascript/debugger/ConsoleMessageBuilder;", "ChromeConnector"})
public final class WipExceptionThrown
implements ConsoleMessage {
    @NotNull
    private final ExceptionThrownEventData message;

    public void print(@NotNull ConsoleView consoleView, @NotNull ConsoleMessageBuilder printer) {
        Intrinsics.checkParameterIsNotNull((Object)consoleView, (String)"consoleView");
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        ExceptionDetailsValue details = this.message.exceptionDetails();
        String string = details.text();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
        printer.append(string, consoleViewContentType);
        Object object = details.getException();
        if (object != null && (object = object.getDescription()) != null) {
            Object object2;
            Object object3 = object;
            Object it = object3;
            int newLinePos = StringsKt.indexOf$default((CharSequence)((CharSequence)it), (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (newLinePos == -1) {
                object2 = it;
            } else {
                Object object4 = it;
                int n = 0;
                Object object5 = object4;
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object5).substring(n, newLinePos);
                object2 = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            Object errorText = object2;
            char c = ' ';
            ConsoleMessageBuilder consoleMessageBuilder = printer;
            String string3 = String.valueOf(c) + (String)errorText;
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.ERROR_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.ERROR_OUTPUT");
            consoleMessageBuilder.append(string3, consoleViewContentType2);
        }
        StackTraceValue stackTraceValue = details.getStackTrace();
        List<CallFrameValue> callFrames = stackTraceValue != null ? stackTraceValue.callFrames() : null;
        String url = details.getUrl();
        if (url != null) {
            List<CallFrameValue> list = callFrames;
            CallFrameValue callFrame = list != null ? (CallFrameValue)CollectionsKt.firstOrNull(list) : null;
            CallFrameValue callFrameValue = callFrame;
            printer.addFileLink(url, details.getLineNumber(), details.getColumnNumber(), callFrameValue != null ? callFrameValue.functionName() : null, true);
        }
        printer.newLine();
        ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType3, (String)"ConsoleViewContentType.ERROR_OUTPUT");
        WipConsoleAPICalledKt.printStackTrace(consoleView, printer, consoleViewContentType3, callFrames);
    }

    @NotNull
    public final ExceptionThrownEventData getMessage() {
        return this.message;
    }

    public WipExceptionThrown(@NotNull ExceptionThrownEventData message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
    }
}

