/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfigurationBase;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfigurationEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.nwjs.NwjsProcessHandler;
import com.jetbrains.nwjs.NwjsProcessState;
import com.jetbrains.nwjs.NwjsRemoteVmConnection;
import java.io.File;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;

final class NwjsRunConfiguration
extends DebuggableProcessRunConfigurationBase {
    public NwjsRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.checkExePath("NW.js interpreter");
    }

    @NotNull
    protected String getInputFileTitle() {
        if ("NW.js app" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "getInputFileTitle"));
        }
        return "NW.js app";
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        DebuggableProcessRunConfigurationEditor<NwjsRunConfiguration> debuggableProcessRunConfigurationEditor = new DebuggableProcessRunConfigurationEditor<NwjsRunConfiguration>(this.getProject()){

            @NotNull
            protected DebuggableProcessRunConfigurationEditor.DebuggableProgramParametersPanel createEditor() {
                DebuggableProcessRunConfigurationEditor.DebuggableProgramParametersPanel editor = super.createEditor();
                editor.inputPathLabel("NW.js app").programParametersLabel("NW.js arguments:").exePathLabel("NW.js interpreter:");
                editor.setAnchor(editor.getAnchor());
                DebuggableProcessRunConfigurationEditor.DebuggableProgramParametersPanel debuggableProgramParametersPanel = editor;
                if (debuggableProgramParametersPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration$1", "createEditor"));
                }
                return debuggableProgramParametersPanel;
            }

            protected FileChooserDescriptor createInputPathDescriptor() {
                return new FileChooserDescriptor(true, true, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file) {
                        boolean selectable = super.isFileSelectable(file);
                        if (!selectable) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            return file.findChild("package.json") != null;
                        }
                        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)".nw");
                    }
                };
            }
        };
        if (debuggableProcessRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "getConfigurationEditor"));
        }
        return debuggableProcessRunConfigurationEditor;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/nwjs/NwjsRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nwjs/NwjsRunConfiguration", "getState"));
        }
        return new NwjsProcessState(this, environment);
    }

    @NotNull
    public String correctExePath(@NotNull String exePath) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/jetbrains/nwjs/NwjsRunConfiguration", "correctExePath"));
        }
        if (SystemInfo.isMac) {
            if (exePath.endsWith("/node-webkit.app")) {
                String string = exePath + "/Contents/MacOS/node-webkit";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "correctExePath"));
                }
                return string;
            }
            if (exePath.endsWith("/nwjs.app")) {
                String string = exePath + "/Contents/MacOS/nwjs";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "correctExePath"));
                }
                return string;
            }
        }
        String string = exePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "correctExePath"));
        }
        return string;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session2, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (socketAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socketAddress", "com/jetbrains/nwjs/NwjsRunConfiguration", "createDebugProcess"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/nwjs/NwjsRunConfiguration", "createDebugProcess"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nwjs/NwjsRunConfiguration", "createDebugProcess"));
        }
        assert (executionResult != null);
        NwjsProcessHandler processHandler = (NwjsProcessHandler)executionResult.getProcessHandler();
        WipRemoteVmConnection connection = processHandler.getVmConnection();
        final DebuggableFileFinderImpl fileFinder = new DebuggableFileFinderImpl(session2.getProject(), connection.getUrl()){

            @Nullable
            protected FileUrlMapper[] computeFileUrlMappers() {
                return new FileUrlMapper[]{new FileUrlMapper(){

                    @Nullable
                    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
                        if (url == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/nwjs/NwjsRunConfiguration$2$1", "getFile"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nwjs/NwjsRunConfiguration$2$1", "getFile"));
                        }
                        String inputPath = NwjsRunConfiguration.this.getInputPath();
                        String expandedPath = PathMacroManager.getInstance((ComponentManager)project).expandPath(inputPath);
                        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(expandedPath);
                        return VfsUtilCore.findRelativeFile((String)url.getPath(), (VirtualFile)root);
                    }
                }};
            }
        };
        BrowserChromeDebugProcess process2 = new BrowserChromeDebugProcess(session2, (DebuggableFileFinder)fileFinder, (VmConnection<?>)connection, executionResult);
        if (connection instanceof NwjsRemoteVmConnection) {
            ((NwjsRemoteVmConnection)connection).getSecondVmConnection().done(secondConnection -> ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    XDebuggerManager.getInstance((Project)this.getProject()).startSessionAndShowTab("app", null, new XDebugProcessStarter((WipRemoteVmConnection)((Object)secondConnection)){
                        final /* synthetic */ WipRemoteVmConnection val$secondConnection;
                        {
                            this.val$secondConnection = wipRemoteVmConnection;
                        }

                        @NotNull
                        public XDebugProcess start(@NotNull XDebugSession session2) throws ExecutionException {
                            if (session2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/nwjs/NwjsRunConfiguration$3", "start"));
                            }
                            BrowserChromeDebugProcess browserChromeDebugProcess = new BrowserChromeDebugProcess(session2, (DebuggableFileFinder)fileFinder, (VmConnection<?>)this.val$secondConnection, null);
                            if (browserChromeDebugProcess == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration$3", "start"));
                            }
                            return browserChromeDebugProcess;
                        }
                    });
                }
                catch (ExecutionException e) {
                    Logger.getInstance(NwjsRunConfiguration.class).warn("Can't start second node webkit debug session", (Throwable)e);
                }
            }));
        }
        connection.open(socketAddress, null);
        BrowserChromeDebugProcess browserChromeDebugProcess = process2;
        if (browserChromeDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "createDebugProcess"));
        }
        return browserChromeDebugProcess;
    }

    @Nullable
    protected String computeDefaultExePath() {
        String appdata;
        File file = null;
        if (SystemInfo.isUnix) {
            if (SystemInfo.isMac) {
                file = new File("/Applications/node-webkit.app/Contents/MacOS/node-webkit");
                if (!file.exists()) {
                    file = new File("/usr/local/lib/node_modules/nodewebkit/nodewebkit/node-webkit.app/Contents/MacOS/node-webkit");
                }
                if (!file.exists()) {
                    file = new File("/Applications/nwjs.app/Contents/MacOS/nwjs");
                }
            }
            if (!(file != null && file.exists() || (file = new File("/usr/local/bin/node-webkit")).exists())) {
                file = new File("/usr/local/bin/nwjs");
            }
        } else if (SystemInfo.isWindows && (appdata = System.getenv("APPDATA")) != null && !(file = new File(appdata, "npm\\node_modules\\nodewebkit\\nodewebkit\\nw.exe")).exists()) {
            file = new File("npm\\node_modules\\nwjs\\nwjs\\nwjs.exe");
        }
        return file == null || !file.exists() ? null : file.getPath();
    }
}

