/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.VmBase;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipBreakpointManager;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipGlobalEvaluateContext;
import org.jetbrains.wip.WipNetworkManager;
import org.jetbrains.wip.WipScriptManager;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm$WhenMappings;
import org.jetbrains.wip.WipVmKt;
import org.jetbrains.wip.WipWorkerManager;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.debugger.BreakpointResolvedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.ScriptParsedEventData;
import org.jetbrains.wip.protocol.debugger.State;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;
import org.jetbrains.wip.protocol.page.FrameValue;
import org.jetbrains.wip.protocol.page.PageKt;
import org.jetbrains.wip.protocol.serviceworker.ServiceWorkerKt;
import org.jetbrains.wip.protocol.target.AttachedToTargetEventData;
import org.jetbrains.wip.protocol.target.DetachedFromTargetEventData;
import org.jetbrains.wip.protocol.target.ReceivedMessageFromTargetEventData;
import org.jetbrains.wip.protocol.target.TargetKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010:\u001a\u0004\u0018\u00010;H\u0014J\u0006\u0010<\u001a\u00020=J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020=0?J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020=0?J\u0006\u0010A\u001a\u00020=J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\nH\u0002J\u0014\u0010E\u001a\u0006\u0012\u0002\b\u00030?2\u0006\u0010D\u001a\u00020\nH\u0016J\u0016\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020\u0005J\u0014\u0010I\u001a\u00020\u00052\n\u0010J\u001a\u0006\u0012\u0002\b\u00030KH$R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u00020\f8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00058V@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R*\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0006@DX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR(\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u0019\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0014R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010#\"\u0004\b,\u0010%R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001c\u00101\u001a\u0002028\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010\u000e\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109\u00a8\u0006L"}, d2={"Lorg/jetbrains/wip/WipVm;", "Lorg/jetbrains/debugger/VmBase;", "tabListener", "Lorg/jetbrains/debugger/DebugEventListener;", "isNode", "", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "(Lorg/jetbrains/debugger/DebugEventListener;ZLorg/jetbrains/wip/WipCommandProcessor;)V", "breakOnExceptionMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "breakpointManager", "Lorg/jetbrains/wip/WipBreakpointManager;", "breakpointManager$annotations", "()V", "getBreakpointManager", "()Lorg/jetbrains/wip/WipBreakpointManager;", "value", "captureAsyncStackTraces", "getCaptureAsyncStackTraces", "()Z", "setCaptureAsyncStackTraces", "(Z)V", "getCommandProcessor", "()Lorg/jetbrains/wip/WipCommandProcessor;", "<set-?>", "Lcom/intellij/util/Url;", "currentUrl", "getCurrentUrl", "()Lcom/intellij/util/Url;", "setCurrentUrl", "(Lcom/intellij/util/Url;)V", "", "frameId", "getFrameId", "()Ljava/lang/String;", "setFrameId", "(Ljava/lang/String;)V", "networkManager", "Lorg/jetbrains/wip/WipNetworkManager;", "getNetworkManager", "()Lorg/jetbrains/wip/WipNetworkManager;", "presentableName", "getPresentableName", "setPresentableName", "scriptManager", "Lorg/jetbrains/wip/WipScriptManager;", "getScriptManager", "()Lorg/jetbrains/wip/WipScriptManager;", "suspendContextManager", "Lorg/jetbrains/wip/WipSuspendContextManager;", "suspendContextManager$annotations", "getSuspendContextManager", "()Lorg/jetbrains/wip/WipSuspendContextManager;", "workerManager", "Lorg/jetbrains/wip/WipWorkerManager;", "getWorkerManager", "()Lorg/jetbrains/wip/WipWorkerManager;", "computeEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "enableDebugger", "", "enableNetwork", "Lorg/jetbrains/concurrency/Promise;", "enablePage", "enableWorkers", "sdkToWipCatchMode", "Lorg/jetbrains/wip/protocol/debugger/State;", "catchMode", "setBreakOnException", "updateUrl", "url", "silent", "write", "message", "Lorg/jetbrains/jsonProtocol/Request;", "wip-backend"})
public abstract class WipVm
extends VmBase {
    @NotNull
    private final WipScriptManager scriptManager;
    @NotNull
    private final WipCommandProcessor commandProcessor;
    @NotNull
    private String presentableName;
    @NotNull
    private final WipBreakpointManager breakpointManager;
    @NotNull
    private final WipSuspendContextManager suspendContextManager;
    @NotNull
    private final WipNetworkManager networkManager;
    @NotNull
    private final WipWorkerManager workerManager;
    private ExceptionCatchMode breakOnExceptionMode;
    @Nullable
    private volatile Url currentUrl;
    @Nullable
    private String frameId;
    private volatile boolean captureAsyncStackTraces;
    private final boolean isNode;

    @NotNull
    public final WipScriptManager getScriptManager() {
        return this.scriptManager;
    }

    @NotNull
    public final WipCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    public void setPresentableName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.presentableName = string;
    }

    public static /* synthetic */ void breakpointManager$annotations() {
    }

    @NotNull
    public WipBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public static /* synthetic */ void suspendContextManager$annotations() {
    }

    @NotNull
    public WipSuspendContextManager getSuspendContextManager() {
        return this.suspendContextManager;
    }

    @NotNull
    public final WipNetworkManager getNetworkManager() {
        return this.networkManager;
    }

    @NotNull
    public final WipWorkerManager getWorkerManager() {
        return this.workerManager;
    }

    @Nullable
    public final Url getCurrentUrl() {
        return this.currentUrl;
    }

    protected final void setCurrentUrl(@Nullable Url url) {
        this.currentUrl = url;
    }

    @Nullable
    public final String getFrameId() {
        return this.frameId;
    }

    private final void setFrameId(String string) {
        this.frameId = string;
    }

    protected abstract boolean write(@NotNull Request<?> var1);

    public final void enableDebugger() {
        this.commandProcessor.send((Request)DebuggerKt.Enable());
    }

    @NotNull
    public final Promise<Unit> enablePage() {
        return this.commandProcessor.send((Request)PageKt.Enable());
    }

    @NotNull
    public final Promise<Unit> enableNetwork() {
        return this.networkManager.enable(this.commandProcessor);
    }

    public final void enableWorkers() {
        this.commandProcessor.send((Request)TargetKt.SetAutoAttach(true, true));
        this.commandProcessor.send((Request)ServiceWorkerKt.Enable());
    }

    public final void updateUrl(@NotNull String url, boolean silent) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.currentUrl = Urls.newFromEncoded((String)url);
        if (silent) {
            return;
        }
        this.scriptManager.clear(this.getDebugListener());
        this.getBreakpointManager().clearNonProvisionalBreakpoints();
        this.getDebugListener().navigated(url);
        this.getSuspendContextManager().getEvaluateHack$wip_backend().pageReloaded$wip_backend();
    }

    @NotNull
    public Promise<?> setBreakOnException(@NotNull ExceptionCatchMode catchMode) {
        Intrinsics.checkParameterIsNotNull((Object)catchMode, (String)"catchMode");
        this.breakOnExceptionMode = catchMode;
        return this.commandProcessor.send((Request)DebuggerKt.SetPauseOnExceptions(this.sdkToWipCatchMode(catchMode)));
    }

    private final State sdkToWipCatchMode(ExceptionCatchMode catchMode) {
        switch (WipVm$WhenMappings.$EnumSwitchMapping$0[catchMode.ordinal()]) {
            case 1: {
                return State.ALL;
            }
            case 2: {
                return State.UNCAUGHT;
            }
            case 3: {
                return State.NONE;
            }
        }
        throw (Throwable)new IllegalArgumentException(catchMode.name());
    }

    @Nullable
    protected EvaluateContext computeEvaluateContext() {
        return (EvaluateContext)new WipGlobalEvaluateContext(new WipValueManager(this, "ce"));
    }

    public boolean getCaptureAsyncStackTraces() {
        return this.captureAsyncStackTraces;
    }

    public void setCaptureAsyncStackTraces(boolean value) {
        this.commandProcessor.send((Request)DebuggerKt.SetAsyncCallStackDepth(value ? WipVmKt.access$getASYNC_CALL_STACK_DEPTH$p() : 0));
        this.captureAsyncStackTraces = value;
    }

    public final boolean isNode() {
        return this.isNode;
    }

    public WipVm(@NotNull DebugEventListener tabListener, boolean isNode, @Nullable WipCommandProcessor commandProcessor2) {
        Intrinsics.checkParameterIsNotNull((Object)tabListener, (String)"tabListener");
        super(tabListener);
        this.isNode = isNode;
        this.scriptManager = new WipScriptManager(this);
        WipCommandProcessor wipCommandProcessor = commandProcessor2;
        if (wipCommandProcessor == null) {
            wipCommandProcessor = new WipCommandProcessor((Function1)new Function1<Request<?>, Boolean>(this){
                final /* synthetic */ WipVm this$0;

                public final boolean invoke(@NotNull Request<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return this.this$0.write(it);
                }
                {
                    this.this$0 = wipVm;
                    super(1);
                }
            });
        }
        this.commandProcessor = wipCommandProcessor;
        this.presentableName = super.getPresentableName();
        this.breakpointManager = new WipBreakpointManager(this);
        this.suspendContextManager = new WipSuspendContextManager(this);
        this.networkManager = new WipNetworkManager(this.commandProcessor.getEventMap());
        this.workerManager = new WipWorkerManager(this);
        this.breakOnExceptionMode = ExceptionCatchMode.NONE;
        EventMap<ProtocolResponseReader> eventMap = this.commandProcessor.getEventMap();
        eventMap.add((EventType)FrameNavigatedEventData.TYPE, (Function1)new Function1<FrameNavigatedEventData, Unit>(){

            public final void invoke(@NotNull FrameNavigatedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                FrameValue frame = it.frame();
                if (frame.getParentId() == null) {
                    frameId = frame.id();
                    this.updateUrl(frame.url(), false);
                }
            }
        });
        eventMap.add((EventType)ScriptParsedEventData.TYPE, (Function1)new Function1<ScriptParsedEventData, Unit>(){

            public final void invoke(@NotNull ScriptParsedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getScriptManager().scriptParsed(it, false);
            }
        });
        eventMap.add((EventType)BreakpointResolvedEventData.TYPE, (Function1)new Function1<BreakpointResolvedEventData, Unit>(){

            public final void invoke(@NotNull BreakpointResolvedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getBreakpointManager().breakpointReportedResolved(it);
            }
        });
        eventMap.add((EventType)AttachedToTargetEventData.TYPE, (Function1)new Function1<AttachedToTargetEventData, Unit>(){

            public final void invoke(@NotNull AttachedToTargetEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getWorkerManager().workerCreated(it, this);
            }
        });
        eventMap.add((EventType)DetachedFromTargetEventData.TYPE, (Function1)new Function1<DetachedFromTargetEventData, Unit>(){

            public final void invoke(@NotNull DetachedFromTargetEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getWorkerManager().workerTerminated(it);
            }
        });
        eventMap.add((EventType)ReceivedMessageFromTargetEventData.TYPE, (Function1)new Function1<ReceivedMessageFromTargetEventData, Unit>(){

            public final void invoke(@NotNull ReceivedMessageFromTargetEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getWorkerManager().workerMessageReceived(it);
            }
        });
    }

    public /* synthetic */ WipVm(DebugEventListener debugEventListener, boolean bl, WipCommandProcessor wipCommandProcessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            wipCommandProcessor = null;
        }
        this(debugEventListener, bl, wipCommandProcessor);
    }

    @Nullable
    public static final /* synthetic */ String access$getFrameId$p(WipVm $this) {
        return $this.frameId;
    }
}

