/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StateStorage {
    @Nullable
    public <T> T getState(@Nullable Object var1, @NotNull String var2, @NotNull Class<T> var3, @Nullable T var4, boolean var5);

    public boolean hasState(@NotNull String var1, boolean var2);

    @Nullable
    public ExternalizationSession startExternalization();

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> var1);

    @NotNull
    default public StateStorageChooserEx.Resolution getResolution(@NotNull PersistentStateComponent<?> component, @NotNull StateStorageOperation operation) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/StateStorage", "getResolution"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/StateStorage", "getResolution"));
        }
        StateStorageChooserEx.Resolution resolution = StateStorageChooserEx.Resolution.DO;
        if (resolution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/StateStorage", "getResolution"));
        }
        return resolution;
    }

    public static interface SaveSession {
        public void save() throws IOException;
    }

    public static interface ExternalizationSession {
        default public void setState(@Nullable Object component, @NotNull String componentName, @NotNull Object state) {
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/StateStorage$ExternalizationSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/StateStorage$ExternalizationSession", "setState"));
            }
        }

        @Nullable
        public SaveSession createSaveSession();
    }
}

