/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.Convertor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SettingsEditorWrapper<Src, Dst>
extends SettingsEditor<Src> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.SettingsEditorWrapper");
    private final Convertor<Src, Dst> mySrcToDstConvertor;
    private final SettingsEditor<Dst> myWrapped;
    private final SettingsEditorListener<Dst> myListener;

    public SettingsEditorWrapper(SettingsEditor<Dst> wrapped, Convertor<Src, Dst> convertor) {
        this.mySrcToDstConvertor = convertor;
        this.myWrapped = wrapped;
        this.myListener = new SettingsEditorListener<Dst>(){

            @Override
            public void stateChanged(SettingsEditor<Dst> settingsEditor) {
                SettingsEditorWrapper.this.fireEditorStateChanged();
            }
        };
        this.myWrapped.addSettingsEditorListener(this.myListener);
    }

    @Override
    public void resetEditorFrom(@NotNull Src src) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/openapi/options/SettingsEditorWrapper", "resetEditorFrom"));
        }
        this.myWrapped.resetFrom(this.mySrcToDstConvertor.convert(src));
    }

    @Override
    public void applyEditorTo(@NotNull Src src) throws ConfigurationException {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/openapi/options/SettingsEditorWrapper", "applyEditorTo"));
        }
        this.myWrapped.applyTo(this.mySrcToDstConvertor.convert(src));
    }

    @Override
    @NotNull
    public JComponent createEditor() {
        JComponent jComponent = this.myWrapped.createEditor();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SettingsEditorWrapper", "createEditor"));
        }
        return jComponent;
    }

    @Override
    public void disposeEditor() {
        this.myWrapped.removeSettingsEditorListener(this.myListener);
        Disposer.dispose(this.myWrapped);
    }
}

