/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsException
extends Exception {
    public static final VcsException[] EMPTY_ARRAY = new VcsException[0];
    private VirtualFile myVirtualFile;
    private Collection<String> myMessages;
    private boolean isWarning;

    public VcsException(String message) {
        super(message);
        this.isWarning = false;
        this.initMessage(message);
    }

    private void initMessage(@Nullable String message) {
        this.myMessages = Collections.singleton(VcsException.prepareMessage(message));
    }

    @NotNull
    private static String prepareMessage(@Nullable String message) {
        String string = (String)ObjectUtils.notNull((Object)message, (Object)VcsBundle.message("exception.text.unknown.error", new Object[0]));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsException", "prepareMessage"));
        }
        return string;
    }

    public VcsException(Throwable throwable, boolean isWarning) {
        this(VcsException.getMessage(throwable), throwable);
        this.isWarning = isWarning;
    }

    public VcsException(Throwable throwable) {
        this(throwable, false);
    }

    public VcsException(String message, Throwable cause) {
        super(message, cause);
        this.isWarning = false;
        this.initMessage(message);
    }

    public VcsException(String message, boolean isWarning) {
        this(message);
        this.isWarning = isWarning;
    }

    public VcsException(@NotNull Collection<String> messages) {
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/intellij/openapi/vcs/VcsException", "<init>"));
        }
        this.isWarning = false;
        this.myMessages = ContainerUtil.map(messages, VcsException::prepareMessage);
    }

    public void setVirtualFile(VirtualFile virtualFile2) {
        this.myVirtualFile = virtualFile2;
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    public String[] getMessages() {
        String[] stringArray = ArrayUtil.toStringArray(this.myMessages);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsException", "getMessages"));
        }
        return stringArray;
    }

    public VcsException setIsWarning(boolean warning) {
        this.isWarning = warning;
        return this;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    @Override
    @NotNull
    public String getMessage() {
        String string = StringUtil.join(this.myMessages, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsException", "getMessage"));
        }
        return string;
    }

    @Nullable
    public static String getMessage(@Nullable Throwable throwable) {
        return throwable != null ? (String)ObjectUtils.chooseNotNull((Object)throwable.getMessage(), (Object)throwable.getLocalizedMessage()) : null;
    }
}

