/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.jarRepository.RepositoryLibraryDefinition;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.util.containers.HashMap;
import icons.OpenapiIcons;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryDescription {
    @NotNull
    public static final String LatestVersionId = "LATEST";
    @NotNull
    public static final String LatestVersionDisplayName = "Latest";
    @NotNull
    public static final String ReleaseVersionId = "RELEASE";
    @NotNull
    public static final String DefaultVersionId = "RELEASE";
    @NotNull
    public static final String ReleaseVersionDisplayName = "Release";
    @NotNull
    public static final String SnapshotVersionSuffix = "-SNAPSHOT";
    public static final Icon DEFAULT_ICON = OpenapiIcons.RepositoryLibraryLogo;
    private static volatile Map<String, RepositoryLibraryDescription> ourStaticallyDefinedLibraries;
    private final String groupId;
    private final String artifactId;
    private final String libraryName;

    protected RepositoryLibraryDescription(String groupId, String artifactId, String libraryName) {
        this.groupId = groupId == null ? "" : groupId;
        this.artifactId = artifactId == null ? "" : artifactId;
        this.libraryName = libraryName == null ? "<unknown>" : libraryName;
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@Nullable String groupId, @Nullable String artifactId) {
        if (ourStaticallyDefinedLibraries == null) {
            HashMap map = new HashMap();
            for (RepositoryLibraryDefinition def : (RepositoryLibraryDefinition[])RepositoryLibraryDefinition.EP_NAME.getExtensions()) {
                String id = def.groupId + ":" + def.artifactId;
                map.put((Object)id, (Object)new RepositoryLibraryDescription(def.groupId, def.artifactId, def.name));
            }
            ourStaticallyDefinedLibraries = Collections.unmodifiableMap(Collections.synchronizedMap(map));
        }
        String id = groupId == null && artifactId == null ? "<unknown>" : groupId + ":" + artifactId;
        RepositoryLibraryDescription description = ourStaticallyDefinedLibraries.get(id);
        RepositoryLibraryDescription repositoryLibraryDescription = description != null ? description : new RepositoryLibraryDescription(groupId, artifactId, id);
        if (repositoryLibraryDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        return repositoryLibraryDescription;
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        RepositoryLibraryDescription repositoryLibraryDescription = RepositoryLibraryDescription.findDescription(properties.getGroupId(), properties.getArtifactId());
        if (repositoryLibraryDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        return repositoryLibraryDescription;
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull JpsMavenRepositoryLibraryDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        RepositoryLibraryDescription repositoryLibraryDescription = RepositoryLibraryDescription.findDescription(descriptor.getGroupId(), descriptor.getArtifactId());
        if (repositoryLibraryDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        return repositoryLibraryDescription;
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getGroupId"));
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getArtifactId"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.libraryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = DEFAULT_ICON;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public DependencyScope getSuggestedScope() {
        return null;
    }

    public int getWeight() {
        return 1000;
    }

    public RepositoryLibraryProperties createDefaultProperties() {
        return new RepositoryLibraryProperties(this.getGroupId(), this.getArtifactId(), "RELEASE", true);
    }

    public String getDisplayName(String version) {
        if (version.equals(LatestVersionId)) {
            version = LatestVersionDisplayName;
        } else if (version.equals("RELEASE")) {
            version = ReleaseVersionDisplayName;
        }
        return this.getDisplayName() + ":" + version;
    }

    public String getMavenCoordinates(String version) {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + version;
    }
}

