/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.files;

import com.intellij.coldFusion.model.files.CfmlFileType;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlImplicitVariable;
import com.intellij.coldFusion.model.psi.CfmlImport;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlRecursiveElementVisitor;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.impl.CfmlTagScriptImpl;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlFile
extends PsiFileBase {
    private final CachedValue<Map<String, CfmlImplicitVariable>> myImplicitVars;
    @NonNls
    public static final String CFMLVARIABLE_MARKER = "@cfmlvariable ";
    @NonNls
    public static final String CFMLJAVALOADER_MARKER = "@javaloader ";
    @NonNls
    public static final Pattern LOADER_DECL_PATTERN_TEMP = Pattern.compile("<!---[\\s]*@javaloader [\\s]*name=\"([^\"]+)\".*[\\s]*(loadPaths=\"([^\"]*)\")[\\s]*--->[\\s]*");
    @NonNls
    public static final Pattern IMPLICIT_VAR_DECL_PATTERN_TEMP = Pattern.compile("<!---[\\s]*@cfmlvariable [\\s]*name=\"([^\"]+)\"[\\s]*type=\"([^\"]*)\"[\\s]*--->[\\s]*");

    CachedValueProvider<Map<String, CfmlImplicitVariable>> createImplicitVarsProvider() {
        return () -> {
            THashMap result = new THashMap();
            this.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Map)result){
                final /* synthetic */ Map val$result;
                {
                    this.val$result = map;
                }

                public void visitComment(PsiComment comment) {
                    String text = comment.getText();
                    String[] nameAndType = CfmlFile.findVariableNameAndType(text);
                    if (nameAndType == null) {
                        return;
                    }
                    CfmlImplicitVariable var = (CfmlImplicitVariable)ContainerUtil.getOrCreate((Map)this.val$result, (Object)nameAndType[0], () -> new CfmlImplicitVariable((PsiFile)CfmlFile.this, comment, nameAndType[0]));
                    var.setType(nameAndType[1]);
                }
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{this});
        };
    }

    public CfmlFile(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/coldFusion/model/files/CfmlFile", "<init>"));
        }
        super(viewProvider, language);
        this.myImplicitVars = CachedValuesManager.getManager((Project)this.getManager().getProject()).createCachedValue(this.createImplicitVarsProvider(), false);
    }

    @NotNull
    public FileType getFileType() {
        CfmlFileType cfmlFileType = CfmlFileType.INSTANCE;
        if (cfmlFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/files/CfmlFile", "getFileType"));
        }
        return cfmlFileType;
    }

    @NotNull
    public String getPresentableName() {
        String string = "CfmlFile:" + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/files/CfmlFile", "getPresentableName"));
        }
        return string;
    }

    public String toString() {
        return this.getPresentableName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/coldFusion/model/files/CfmlFile", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/coldFusion/model/files/CfmlFile", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/coldFusion/model/files/CfmlFile", "processDeclarations"));
        }
        if (!this.processExportableDeclarations(processor, state)) {
            return false;
        }
        return CfmlPsiUtil.processDeclarations(processor, state, lastParent, (PsiElement)this);
    }

    private boolean processExportableDeclarations(PsiScopeProcessor processor, ResolveState state) {
        for (CfmlImplicitVariable var : ((Map)this.myImplicitVars.getValue()).values()) {
            if (processor.execute((PsiElement)var, state)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String[] findVariableNameAndType(String text) {
        Matcher matcher = IMPLICIT_VAR_DECL_PATTERN_TEMP.matcher(text);
        Matcher javaLoaderMatcher = LOADER_DECL_PATTERN_TEMP.matcher(text);
        if (!matcher.matches()) {
            if (!javaLoaderMatcher.matches()) {
                return null;
            }
            return new String[]{javaLoaderMatcher.group(1), "javaloader"};
        }
        return new String[]{matcher.group(1), matcher.group(2)};
    }

    @Nullable
    public CfmlImplicitVariable findImplicitVariable(String name) {
        return (CfmlImplicitVariable)((Map)this.myImplicitVars.getValue()).get(name);
    }

    public Collection<CfmlFunction> getGlobalFunctions() {
        final LinkedList<CfmlFunction> result = new LinkedList<CfmlFunction>();
        this.accept(new CfmlRecursiveElementVisitor(){

            @Override
            public void visitCfmlFunction(CfmlFunction function) {
                result.add(function);
            }

            @Override
            public void visitCfmlComponent(CfmlComponent component) {
            }

            @Override
            public void visitElement(PsiElement element) {
                if (element instanceof CfmlFile || element instanceof CfmlTag) {
                    super.visitElement(element);
                }
            }
        });
        return result;
    }

    @Nullable
    public CfmlComponent getComponentDefinition() {
        final Ref ref = new Ref(null);
        this.accept(new CfmlRecursiveElementVisitor(){

            @Override
            public void visitCfmlFunction(CfmlFunction function) {
            }

            @Override
            public void visitCfmlComponent(CfmlComponent component) {
                ref.set((Object)component);
            }

            @Override
            public void visitCfmlTag(CfmlTag tag) {
                if (tag instanceof CfmlTagScriptImpl) {
                    super.visitCfmlTag(tag);
                }
            }

            @Override
            public void visitElement(PsiElement element) {
                if (element instanceof CfmlFile || element instanceof CfmlTagScriptImpl) {
                    super.visitElement(element);
                }
            }
        });
        return (CfmlComponent)ref.get();
    }

    public String getComponentQualifiedName(@NotNull String componentName) {
        CfmlImport[] childrenByClass;
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/coldFusion/model/files/CfmlFile", "getComponentQualifiedName"));
        }
        for (CfmlImport importStatement : childrenByClass = (CfmlImport[])this.findChildrenByClass(CfmlImport.class)) {
            if (!importStatement.isImported(componentName)) continue;
            String importString = importStatement.getImportString();
            return importString != null ? importString : "";
        }
        return componentName;
    }

    public Collection<String> getImportStrings() {
        CfmlImport[] childrenByClass;
        HashSet result = new HashSet();
        for (CfmlImport importStatement : childrenByClass = (CfmlImport[])this.findChildrenByClass(CfmlImport.class)) {
            String importString = importStatement.getImportString();
            if (importString == null) continue;
            result.add(importString);
        }
        return result;
    }
}

