/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.gga.graph.maps.DataGraph;

public class ModuleGroupSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    private final ModuleGrouper myGrouper;

    public ModuleGroupSplitter(ModuleGrouper grouper) {
        this.myGrouper = grouper;
    }

    @Override
    public List<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, BooleanFunction<ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        List currentPath = parentData instanceof MyNodeData ? ((MyNodeData)parentData).myGroups : Collections.emptyList();
        HashSet subGroupsSet = new HashSet();
        boolean modulesInsideFound = false;
        boolean classedOutOfModulesFound = false;
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode2 = dataGraph.getNode(i);
            if (!memberFunction.fun((Object)classNode2)) continue;
            Module module = classNode2.module;
            if (module == null && currentPath.isEmpty()) {
                classedOutOfModulesFound = true;
                continue;
            }
            List p = this.myGrouper.getGroupPath(module);
            if (Comparing.equal((Object)currentPath, (Object)p)) {
                modulesInsideFound = true;
                continue;
            }
            if (!ContainerUtil.startsWith((List)p, (List)currentPath)) continue;
            subGroupsSet.add(p.get(currentPath.size()));
        }
        ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> result = new ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>>();
        Object[] groups = ArrayUtil.toStringArray(subGroupsSet);
        Arrays.sort(groups);
        for (Object group : groups) {
            List subPath = ContainerUtil.append((List)currentPath, (Object[])new String[]{group});
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(classNode -> {
                Module module = classNode.module;
                List p = this.myGrouper.getGroupPath(module);
                return ContainerUtil.startsWith((List)p, (List)subPath);
            }, (Object)new MyNodeData((String)group, StringUtil.join((Collection)subPath, (String)"."), AllIcons.Nodes.ModuleGroup, subPath)));
        }
        if (modulesInsideFound) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(classNode -> {
                Module module = classNode.module;
                List p = this.myGrouper.getGroupPath(module);
                return Comparing.equal((Object)p, (Object)currentPath);
            }, null));
        }
        if (classedOutOfModulesFound) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(classNode -> {
                Module module = classNode.module;
                return module == null;
            }, null));
        }
        return result;
    }

    private static class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        private final List<String> myGroups;

        public MyNodeData(String shortName, String fullName, Icon icon, List<String> groups) {
            super(shortName, fullName, icon);
            this.myGroups = groups;
        }
    }
}

