/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.NodeVisitor;
import com.intellij.ui.JBColor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;

class BandPainter<N>
implements NodeVisitor<N> {
    private final Graphics2D g;
    private final DsmTableImpl<N> myDsmTable;

    public BandPainter(DsmTableImpl<N> dsmTable, Graphics2D g) {
        this.myDsmTable = dsmTable;
        this.g = g;
    }

    @Override
    public void visitLeaf(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
    }

    @Override
    public void visitExpanded(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isLast) {
        Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(node);
        if (node.getParent().getRawChildren().length == 1 || r.height == this.myDsmTable.myBoxSize) {
            return;
        }
        Rectangle clipBounds = this.g.getClipBounds();
        if (clipBounds != null && !clipBounds.intersects(r.y + 1, r.y + 1, r.height, r.height)) {
            return;
        }
        this.g.setPaint((Paint)JBColor.BLACK);
        this.g.drawRect(r.y + 1, r.y + 1, r.height, r.height);
    }

    @Override
    public void visitCollapsed(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean last) {
    }
}

