/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmSelectionModel;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.SelectionVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class DsmSelectionModelImpl<N>
implements DsmSelectionModel<N> {
    private final Set<DsmSelection<N>> mySelection = new HashSet<DsmSelection<N>>();
    private final Set<DsmTreeStructure.TreeNode> mySelectedNodes = new HashSet<DsmTreeStructure.TreeNode>();
    private final DsmTableImpl<N> myDsmTable;
    private final List<DsmSelectionModel.DsmSelectionModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private DsmSelection<N> myLead = null;

    public DsmSelectionModelImpl(DsmTableImpl<N> dsmTable) {
        this.myDsmTable = dsmTable;
    }

    @Override
    public boolean isSelected(DsmTreeStructure.TreeNode<N> node) {
        return this.mySelectedNodes.contains(node);
    }

    @Override
    public void acceptSelection(SelectionVisitor<N> visitor) {
        block4: for (DsmSelection<N> selection : this.mySelection) {
            switch (selection.type) {
                case CELL: {
                    visitor.visitCellSelection(selection);
                    continue block4;
                }
                case ROW: {
                    visitor.visitRowSelection(selection);
                    continue block4;
                }
            }
            assert (false);
        }
    }

    @Override
    public Collection<DsmSelection<N>> getSelection() {
        return Collections.unmodifiableCollection(this.mySelection);
    }

    @Override
    public void addSelection(DsmSelection<N> selection) {
        this._addSelection(selection);
        this.myLead = selection;
        this.fireSelectionChanged();
    }

    private void _addSelection(DsmSelection<N> selection) {
        Iterator<DsmSelection<N>> i = this.mySelection.iterator();
        while (i.hasNext()) {
            DsmSelection<N> s = i.next();
            if (s.type == DsmSelection.Type.ROW && selection.type == DsmSelection.Type.ROW && selection.node1.containsAll(s.node1)) {
                i.remove();
            }
            if (s.type != DsmSelection.Type.CELL || selection.type != DsmSelection.Type.CELL || !selection.node1.containsAll(s.node1) || !selection.node2.containsAll(s.node2)) continue;
            i.remove();
        }
        this.mySelection.add(selection);
        this.mySelectedNodes.addAll(selection.node1);
        this.mySelectedNodes.addAll(selection.node2);
    }

    @Override
    public void expandSelection(@NotNull DsmSelection<N> selection) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/dsm/ui/DsmSelectionModelImpl", "expandSelection"));
        }
        if (this.myLead == null || this.myLead.type != selection.type) {
            this.addSelection(selection);
            return;
        }
        if (selection.type == DsmSelection.Type.ROW && this.myLead.type == selection.type) {
            this.expandRow(selection);
        } else {
            this.expandCell(selection);
        }
        this.fireSelectionChanged();
    }

    private void expandCell(DsmSelection<N> selection) {
        assert (selection.type == DsmSelection.Type.CELL);
        List rows = this.myDsmTable.myCache.myRows;
        int start1 = Integer.MAX_VALUE;
        int end1 = -1;
        int start2 = Integer.MAX_VALUE;
        int end2 = -1;
        for (int i = 0; i < rows.size(); ++i) {
            DsmTreeStructure.TreeNode row = rows.get(i);
            if (this.myLead.node1.contains(row) || selection.node1.contains(row)) {
                start1 = Math.min(start1, i);
                end1 = Math.max(end1, i);
            }
            if (!this.myLead.node2.contains(row) && !selection.node2.contains(row)) continue;
            start2 = Math.min(start2, i);
            end2 = Math.max(end2, i);
        }
        assert (end1 >= 0);
        assert (start1 < Integer.MAX_VALUE);
        assert (end2 >= 0);
        assert (start2 < Integer.MAX_VALUE);
        HashSet<DsmTreeStructure.TreeNode<N>> newNodes1 = new HashSet<DsmTreeStructure.TreeNode<N>>();
        HashSet<DsmTreeStructure.TreeNode<N>> newNodes2 = new HashSet<DsmTreeStructure.TreeNode<N>>();
        this.addInterval(rows, start1, end1, newNodes1);
        this.addInterval(rows, start2, end2, newNodes2);
        for (DsmSelection<N> s : this.mySelection) {
            if (s.type != DsmSelection.Type.CELL || !ContainerUtil.intersects(s.node1, newNodes1) || !ContainerUtil.intersects(s.node2, newNodes2)) continue;
            start1 = Math.min(start1, s.start1);
            start2 = Math.min(start2, s.start2);
            end1 = Math.max(end1, s.end1);
            end2 = Math.max(end2, s.end2);
        }
        this.addInterval(rows, start1, end1, newNodes1);
        this.addInterval(rows, start2, end2, newNodes2);
        this._addSelection(DsmSelection.createCellSelection(newNodes1, newNodes2, start1, end1, start2, end2));
    }

    private void addInterval(List<DsmTreeStructure.TreeNode<N>> rows, int start, int end, Set<DsmTreeStructure.TreeNode<N>> newNodes1) {
        for (int i = start; i <= end; ++i) {
            DsmTreeStructure.TreeNode<N> node = rows.get(i);
            newNodes1.add(node);
        }
    }

    private void expandRow(DsmSelection<N> selection) {
        List rows = this.myDsmTable.myCache.myRows;
        int start = Integer.MAX_VALUE;
        int end = -1;
        for (int i = 0; i < rows.size(); ++i) {
            DsmTreeStructure.TreeNode row = rows.get(i);
            if (!this.myLead.node1.contains(row) && !selection.node1.contains(row)) continue;
            start = Math.min(start, i);
            end = Math.max(end, i);
        }
        assert (end >= 0);
        assert (start < Integer.MAX_VALUE);
        HashSet<DsmTreeStructure.TreeNode<N>> newNodes = new HashSet<DsmTreeStructure.TreeNode<N>>();
        this.addInterval(rows, start, end, newNodes);
        for (DsmSelection<N> s : this.mySelection) {
            if (s.type != DsmSelection.Type.ROW || !ContainerUtil.intersects(s.node1, newNodes)) continue;
            start = Math.min(start, s.start1);
            end = Math.max(end, s.end1);
        }
        if (this.mySelectedNodes.containsAll(newNodes)) {
            return;
        }
        this._addSelection(DsmSelection.createRowSelection(newNodes, start, end));
    }

    @Override
    public DsmSelection<N> createCellSelection(DsmTreeStructure.TreeNode<N> row, DsmTreeStructure.TreeNode<N> col) {
        return DsmSelection.createCellSelection(row, col, this.myDsmTable.myCache.rowIndices.get(row), this.myDsmTable.myCache.rowIndices.get(col));
    }

    @Override
    public void addSelectionModelListener(DsmSelectionModel.DsmSelectionModelListener listener) {
        this.myListeners.add(listener);
    }

    private void fireSelectionChanged() {
        for (DsmSelectionModel.DsmSelectionModelListener listener : this.myListeners) {
            listener.selectionChanged();
        }
    }

    @Override
    public void clear() {
        this.mySelection.clear();
        this.mySelectedNodes.clear();
        this.myLead = null;
        this.fireSelectionChanged();
    }
}

