/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.jsp.WrapInTagFix;
import com.intellij.codeInspection.jsp.unescapedEl.SafeTagInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JspAbsolutePathInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/jsp/JspAbsolutePathInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                PsiReference[] references;
                if (!value.getValue().startsWith("/") || !HtmlUtil.isHtmlTagContainingFile((PsiElement)value)) {
                    return;
                }
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class);
                if (tag == null || !tag.getNamespacePrefix().isEmpty()) {
                    return;
                }
                JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)value);
                if (jspFile == null) {
                    return;
                }
                for (PsiReference reference : references = value.getReferences()) {
                    if (!(reference instanceof FileReferenceOwner)) continue;
                    PsiFileReference fileReference = ((FileReferenceOwner)reference).getLastFileReference();
                    if (fileReference instanceof FileReference && ((FileReference)fileReference).getFileReferenceSet().isAbsolutePathReference()) {
                        ArrayList<Object> fixes = new ArrayList<Object>(2);
                        PsiFile file = value.getContainingFile();
                        if (!(file instanceof JspFile) && JspManager.getInstance((Project)value.getProject()).getTldFileByUri("http://java.sun.com/jsp/jstl/core", jspFile) != null) {
                            fixes.add(new WrapInTagFix(new SafeTagInfo("http://java.sun.com/jsp/jstl/core", "url", "value", true)));
                        }
                        fixes.add(new AddDynamicPrefixFix());
                        TextRange range = ElementManipulators.getValueTextRange((PsiElement)value);
                        holder.registerProblem((PsiElement)value, range, "Absolute paths not recommended in JSPs", fixes.toArray(new LocalQuickFix[fixes.size()]));
                    }
                    return;
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspAbsolutePathInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspAbsolutePathInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Absolute paths" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspAbsolutePathInspection", "getDisplayName"));
        }
        return "Absolute paths";
    }

    @NotNull
    public String getShortName() {
        if ("JspAbsolutePathInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspAbsolutePathInspection", "getShortName"));
        }
        return "JspAbsolutePathInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static class AddDynamicPrefixFix
    implements LocalQuickFix {
        private AddDynamicPrefixFix() {
        }

        @NotNull
        public String getName() {
            if ("Add dynamic prefix" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspAbsolutePathInspection$AddDynamicPrefixFix", "getName"));
            }
            return "Add dynamic prefix";
        }

        @NotNull
        public String getFamilyName() {
            String string = JspInspectionGroupNames.JSP_INSPECTIONS;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspAbsolutePathInspection$AddDynamicPrefixFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/jsp/JspAbsolutePathInspection$AddDynamicPrefixFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/jsp/JspAbsolutePathInspection$AddDynamicPrefixFix", "applyFix"));
            }
            XmlAttributeValue value = (XmlAttributeValue)descriptor.getPsiElement();
            JspFile jsp = JspPsiUtil.getJspFile((PsiElement)value);
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)jsp);
            TextRange range = value.getValueTextRange();
            document.insertString(range.getStartOffset(), (CharSequence)"${pageContext.request.contextPath}");
        }
    }
}

