/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiJavaFileBaseImpl;
import com.intellij.psi.impl.source.jsp.JspContextManagerImpl;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportList;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.jsp.JspElementTypeEx;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspJavaFileImpl
extends PsiJavaFileBaseImpl {
    private volatile PsiClass[] myClasses;
    @NonNls
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang", "javax.servlet", "javax.servlet.jsp", "javax.servlet.http"};

    public JspJavaFileImpl(FileViewProvider viewProvider) {
        super((IElementType)JspElementTypeEx.JSP_JAVA_DECLARATIONS_ROOT, (IElementType)JspElementTypeEx.JSP_JAVA_DECLARATIONS_ROOT, viewProvider);
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getViewProvider().getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getFileType"));
        }
        return fileType;
    }

    @NotNull
    public JspxFileViewProvider getViewProvider() {
        JspxFileViewProvider jspxFileViewProvider = (JspxFileViewProvider)super.getViewProvider();
        if (jspxFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getViewProvider"));
        }
        return jspxFileViewProvider;
    }

    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] classes = this.myClasses;
        if (classes == null) {
            classes = new PsiClass[]{this.getJavaClass()};
            this.myClasses = classes;
        }
        if (classes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getClasses"));
        }
        return classes;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "processDeclarations"));
        }
        return super.processDeclarations(processor, state, lastParent, place) && JspContextManagerImpl.getInstance(this.getProject()).processContextElements((FileViewProvider)this.getViewProvider(), processor);
    }

    public PsiPackageStatement getPackageStatement() {
        return null;
    }

    @NotNull
    public String getPackageName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getPackageName"));
        }
        return "";
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for jsp files");
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile original = super.getOriginalFile();
        if (original == this) {
            PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)this);
            PsiFile baseOriginal = psiFile.getOriginalFile();
            PsiFile psiFile2 = baseOriginal.getViewProvider().getPsi(this.getLanguage());
            if (psiFile2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getOriginalFile"));
            }
            return psiFile2;
        }
        PsiFile psiFile = original;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getOriginalFile"));
        }
        return psiFile;
    }

    @NotNull
    public JspxImportList getImportList() {
        FileElement element = this.calcTreeElement();
        JspxImportList jspxImportList = (JspxImportList)element.findChildByType(JspElementTypeEx.JSP_IMPORT_LIST_WRAPPER).getPsi();
        if (jspxImportList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getImportList"));
        }
        return jspxImportList;
    }

    public JspClass getJavaClass() {
        FileElement element = this.calcTreeElement();
        return (JspClass)element.findChildByType(JspElementType.JSP_CLASS).getPsi();
    }

    public void clearCaches() {
        super.clearCaches();
        this.myClasses = null;
    }

    public String toString() {
        return "Jspx DummyHolder";
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        JspxFileViewProvider viewProvider = this.getViewProvider();
        PsiFile[] psiFileArray = viewProvider.getPsi(viewProvider.getBaseLanguage()).getPsiRoots();
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getPsiRoots"));
        }
        return psiFileArray;
    }

    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getImplicitlyImportedPackages"));
        }
        return IMPLICIT_IMPORTS;
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences((PsiManager)this.myManager, (String[])IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspJavaFileImpl", "getImplicitlyImportedPackageReferences"));
        }
        return psiJavaCodeReferenceElementArray;
    }
}

