/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.jsp;

import com.intellij.codeInsight.daemon.impl.analysis.encoding.JspEncodingInAttributeReferenceProvider;
import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReference;
import com.intellij.javaee.web.WebUtil;
import com.intellij.jsp.index.JspDirectiveCollector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JspxIncludePathReferenceProvider;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.behavior.CDATAOnAnyEncodedPolicy;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JavaJspElementVisitor;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.CharTable;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspUtil
extends BaseJspUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.jsp.JspUtil");
    @NonNls
    public static final String JSF_CORE_TAGLIB_URI = "http://java.sun.com/jsf/core";
    @NonNls
    public static final String JSF_HTML_TAGLIB_URI = "http://java.sun.com/jsf/html";
    public static final Function<ResolveResult, PsiFileSystemItem> MAPPING = result -> (PsiFileSystemItem)result.getElement();

    private JspUtil() {
    }

    public static int escapeCharsInJspContext(JspFile file, int offset, String toEscape) throws IncorrectOperationException {
        PsiElement elementAtInJavaTree;
        if (!XmlUtil.toCode((String)toEscape) || file.getLanguage() != StdLanguages.JSPX) {
            return 0;
        }
        XmlFile psiFile = (XmlFile)file.getViewProvider().getPsi((Language)JSPXLanguage.INSTANCE);
        XmlDocument document = psiFile.getDocument();
        PsiElement elementAt = document.findElementAt(offset);
        if (elementAt == null && offset > 0) {
            elementAt = document.findElementAt(offset - 1);
        }
        if (elementAt == null) {
            return 0;
        }
        ASTNode cdata = TreeUtil.findParent((ASTNode)elementAt.getNode(), (IElementType)XmlElementType.XML_CDATA);
        if (cdata != null) {
            return 0;
        }
        final XmlText parentOfType = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)elementAt, XmlText.class);
        if (parentOfType == null) {
            return 0;
        }
        PsiClass aClass = file.getJavaClass();
        if (aClass != null && (elementAtInJavaTree = aClass.findElementAt(offset)) instanceof OuterLanguageElement) {
            return 0;
        }
        final FileElement cdataElement = CDATAOnAnyEncodedPolicy.createCDATAElement((PsiManager)file.getManager(), (CharTable)file.getNode().getCharTable(), (String)parentOfType.getValue());
        PomModel model = PomManager.getModel((Project)file.getProject());
        model.runTransaction((PomTransaction)new PomTransactionBase(parentOfType.getParent(), model.getModelAspect(XmlAspect.class)){

            @Nullable
            public PomModelEvent runInner() {
                parentOfType.getNode().replaceAllChildrenToChildrenOf((ASTNode)cdataElement);
                return null;
            }
        });
        return "<![CDATA[".length();
    }

    @Nullable
    public static Language getLanguageByContentType(String contentType) {
        if (contentType == null || contentType.isEmpty()) {
            return null;
        }
        int endOfContentMimeType = contentType.indexOf(59);
        if (endOfContentMimeType >= 0) {
            contentType = contentType.substring(0, endOfContentMimeType);
        }
        if (contentType.isEmpty()) {
            return null;
        }
        return (Language)ContainerUtil.getFirstItem((Collection)Language.findInstancesByMimeType((String)contentType), (Object)StdLanguages.XML);
    }

    @Nullable
    public static JspFile resolveIncludeDirective(XmlTag tag) {
        PsiFile file = JspUtil.resolveFileInclude(tag);
        if (file == null) {
            return null;
        }
        return JspPsiUtil.getJspFile((PsiElement)file);
    }

    @Nullable
    public static PsiFile resolveFileInclude(XmlTag tag) {
        assert (tag.isValid());
        LOG.assertTrue(JspUtil.getDirectiveKindByTag(tag) == JspDirectiveKind.INCLUDE);
        return JspUtil.resolvePsiFileReferenceInAttribute(tag, "file");
    }

    @Nullable
    public static String getIncludedFilePath(XmlTag tag) {
        return tag.getAttributeValue("file");
    }

    @Nullable
    protected static JspFile resolvePsiFileReferenceInAttribute(XmlTag tag, @NonNls String attributeName) {
        XmlAttribute attribute = tag.getAttribute(attributeName, null);
        if (attribute == null) {
            return null;
        }
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement == null) {
            return null;
        }
        PsiFile file = JspUtil.resolveFileReference((PsiElement)valueElement);
        return file == null ? null : JspPsiUtil.getJspFile((PsiElement)file);
    }

    @Nullable
    public static PsiFileSystemItem resolveReferenceSet(FileReferenceSet referenceSet, PsiFile context) {
        FileReference lastReference = referenceSet.getLastReference();
        if (lastReference == null) {
            return null;
        }
        ResolveResult[] results = lastReference.multiResolve(false);
        if (results.length == 0) {
            return null;
        }
        for (ResolveResult result : results) {
            if (result != null) continue;
            LOG.error(lastReference + " returned null");
        }
        if (results.length == 1) {
            return (PsiFile)results[0].getElement();
        }
        PsiFile psiFile = null;
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null) {
            return (PsiFile)results[0].getElement();
        }
        String path = virtualFile.getParent().getPath();
        for (ResolveResult result : results) {
            PsiFile file;
            if (!result.isValidResult() || !(result.getElement() instanceof PsiFile) || !(file = (PsiFile)result.getElement()).getVirtualFile().getPath().startsWith(path) || psiFile != null && file.getVirtualFile().getPath().length() >= psiFile.getVirtualFile().getPath().length()) continue;
            psiFile = file;
        }
        return psiFile != null ? psiFile : (PsiFile)results[0].getElement();
    }

    @Nullable
    private static PsiFile resolveFileReference(@NotNull PsiElement valueElement) {
        if (valueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "com/intellij/psi/jsp/JspUtil", "resolveFileReference"));
        }
        FileReferenceSet referenceSet = JspxIncludePathReferenceProvider.getFileReferenceSet((String)StringUtil.unquoteString((String)valueElement.getText()), (PsiElement)valueElement, (int)1, null);
        PsiFileSystemItem item = JspUtil.resolveReferenceSet(referenceSet, valueElement.getContainingFile());
        return item instanceof PsiFile ? (PsiFile)item : null;
    }

    @Nullable
    public static Module getModuleForPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/jsp/JspUtil", "getModuleForPsiElement"));
        }
        VirtualFile file = JspPsiUtil.getJspFile((PsiElement)element.getContainingFile()).getVirtualFile();
        return file == null ? null : ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getModuleForFile(file);
    }

    public static <T extends BaseJspFile> void visitAllIncludedFilesRecursively(T jspFile, Processor<T> visitor, boolean includesOnly) {
        Set<T> files = JspUtil.collectAllIncludedFilesRecursively(jspFile, includesOnly);
        for (T file : files) {
            if (visitor.process(file)) continue;
            return;
        }
    }

    public static <T extends BaseJspFile> Set<T> collectAllIncludedFilesRecursively(T jspFile, boolean includesOnly) {
        HashSet result = new HashSet(10);
        JspUtil.collectAllIncludedFilesRecursively(jspFile, result, includesOnly, DumbService.getInstance((Project)jspFile.getProject()).isDumb());
        return result;
    }

    private static <T extends BaseJspFile> void collectAllIncludedFilesRecursively(BaseJspFile jspFile, Set<T> result, boolean includesOnly, boolean dumbMode) {
        JspUtil.addPreludes(jspFile, result, includesOnly, dumbMode);
        JspUtil.addIncludes(jspFile, result, includesOnly, dumbMode);
        JspUtil.addCodas(jspFile, result, includesOnly, dumbMode);
    }

    public static <T extends BaseJspFile> void addIncludes(BaseJspFile jspFile, final Set<T> result, boolean includesOnly, boolean dumbMode) {
        if (dumbMode) {
            Collection<XmlTag> tags = JspDirectiveCollector.collectDirectives(jspFile, JspDirectiveKind.INCLUDE);
            for (XmlTag tag : tags) {
                JspFile file = JspUtil.resolveIncludeDirective(tag);
                if (file == null || !result.add(file)) continue;
                JspUtil.collectAllIncludedFilesRecursively((BaseJspFile)file, result, true, true);
            }
        } else {
            JspFileIndex.getInstance(jspFile.getProject()).traverseIncludesGraph(jspFile, new JspFileIndex.JspFileProcessor(){

                @Override
                public boolean process(@NotNull BaseJspFile file, int includeDirectiveOffset, boolean isInclude) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/jsp/JspUtil$2", "process"));
                    }
                    result.add(file);
                    return true;
                }
            }, includesOnly);
        }
    }

    public static <T extends BaseJspFile> void addPreludes(BaseJspFile jspFile, Set<T> toVisit, boolean includesOnly, boolean dumbMode) {
        for (PathReference prelude : WebUtil.getPreludes((BaseJspFile)jspFile)) {
            PsiElement file = prelude.resolve();
            if (!(file instanceof BaseJspFile) || !toVisit.add((BaseJspFile)file)) continue;
            JspUtil.collectAllIncludedFilesRecursively((BaseJspFile)file, toVisit, includesOnly, dumbMode);
        }
    }

    private static <T extends BaseJspFile> void addCodas(BaseJspFile jspFile, Set<T> toVisit, boolean includesOnly, boolean dumbMode) {
        for (PathReference prelude : WebUtil.getCodas((BaseJspFile)jspFile)) {
            PsiElement file = prelude.resolve();
            if (!(file instanceof BaseJspFile) || !toVisit.add((BaseJspFile)file)) continue;
            JspUtil.collectAllIncludedFilesRecursively((BaseJspFile)file, toVisit, includesOnly, dumbMode);
        }
    }

    public static void visitAllIncludes(JspFile jspFile, Set<XmlTag> toVisit, JavaJspElementVisitor visitor) {
        HashSet<JspFile> filesToVisit = new HashSet<JspFile>(10);
        boolean dumbMode = DumbService.getInstance((Project)jspFile.getProject()).isDumb();
        JspUtil.addPreludes((BaseJspFile)jspFile, filesToVisit, true, dumbMode);
        for (XmlTag tag : toVisit) {
            JspFile file = JspUtil.resolveIncludeDirective(tag);
            if (file == null || !filesToVisit.add(file)) continue;
            JspUtil.collectAllIncludedFilesRecursively((BaseJspFile)file, filesToVisit, true, dumbMode);
        }
        for (JspFile file : filesToVisit) {
            visitor.visitJspFile(file);
        }
    }

    @Nullable
    public static String checkValidNameFromAttribute(XmlTag tag) {
        String requiredValue = tag.getAttributeValue("required");
        if ("false".equals(requiredValue)) {
            return "name.from.attribute.should.be.required";
        }
        String typeValue = tag.getAttributeValue("type");
        if (!"java.lang.String".equals(typeValue)) {
            return "name.from.attribute.should.be.java.lang.String";
        }
        String runtimeValue = tag.getAttributeValue("rtexprvalue");
        if (!"false".equals(runtimeValue)) {
            return "name.from.attribute.should.not.be.rtexprvalue";
        }
        return null;
    }

    @Nullable
    private static Charset detectCharsetFromDirectives(@NotNull CharSequence content, @NotNull Language language) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/jsp/JspUtil", "detectCharsetFromDirectives"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/jsp/JspUtil", "detectCharsetFromDirectives"));
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (definition == null) {
            LOG.error(language.getID());
            return null;
        }
        Lexer lexer = definition.createLexer(null);
        lexer.start(content);
        final Ref charsetNameRef = new Ref();
        while (lexer.getTokenType() != null) {
            IElementType tokenType = lexer.getTokenType();
            if (tokenType == BaseJspElementType.JSP_DIRECTIVE) {
                ASTNode parsed = BaseJspElementType.JSP_DIRECTIVE.parse(LexerUtil.getTokenText((Lexer)lexer), (CharTable)IdentityCharTable.INSTANCE);
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                Project project = projects.length == 0 ? ProjectManager.getInstance().getDefaultProject() : projects[0];
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                new DummyHolder(psiManager, (TreeElement)parsed, null, null, null, BaseJspElementType.JSP_DIRECTIVE.getLanguage());
                PsiElement psiElement = parsed.getPsi();
                assert (psiElement != null);
                psiElement.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttributeValue(XmlAttributeValue value) {
                        for (PsiReference reference : JspEncodingInAttributeReferenceProvider.getReferencesByElement((PsiElement)value)) {
                            if (!(reference instanceof XmlEncodingReference) || reference.resolve() == null) continue;
                            XmlEncodingReference prev = (XmlEncodingReference)charsetNameRef.get();
                            XmlEncodingReference xmlRef = (XmlEncodingReference)reference;
                            if (prev != null && prev.compareTo(xmlRef) >= 0) continue;
                            charsetNameRef.set((Object)xmlRef);
                        }
                        super.visitXmlAttributeValue(value);
                    }
                });
            }
            lexer.advance();
        }
        XmlEncodingReference ref = (XmlEncodingReference)charsetNameRef.get();
        String name = ref == null ? null : ref.getCanonicalText();
        return CharsetToolkit.forName((String)name);
    }

    @Nullable
    private static Charset detectCharsetFromWebXml(@NotNull JspFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/jsp/JspUtil", "detectCharsetFromWebXml"));
        }
        Ref result = new Ref();
        WebUtil.processMatchingJspGroups((PsiFile)file, group -> {
            result.set((Object)CharsetToolkit.forName((String)((String)group.getPageEncoding().getValue())));
            return !result.isNull();
        });
        return (Charset)result.get();
    }

    @Nullable
    public static Charset detectCharsetAsPerJspSpec(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content, @NotNull Language language) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/jsp/JspUtil", "detectCharsetAsPerJspSpec"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/jsp/JspUtil", "detectCharsetAsPerJspSpec"));
        }
        return (Charset)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            Charset charset;
            PsiFile psiFile;
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/jsp/JspUtil", "lambda$detectCharsetAsPerJspSpec$2"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/jsp/JspUtil", "lambda$detectCharsetAsPerJspSpec$2"));
            }
            if (project != null && project.isInitialized() && !project.isDisposed() && file != null && file.isValid() && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof JspFile && (charset = JspUtil.detectCharsetFromWebXml((JspFile)psiFile)) != null) {
                return charset;
            }
            return JspUtil.detectCharsetFromDirectives(content, language);
        }));
    }

    @Nullable
    public static String detectCharsetAsPerJspSpec(VirtualFile jspFile, byte[] content, Language language) {
        try {
            String strContent = new String(content, "ISO-8859-1");
            Project project = ProjectUtil.guessProjectForFile((VirtualFile)jspFile);
            Charset charset = JspUtil.detectCharsetAsPerJspSpec(project, jspFile, strContent, language);
            return charset == null ? null : charset.name();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static boolean isFacesJsp(BaseJspFile jspFile) {
        XmlDocument document = jspFile.getDocument();
        if (document == null) {
            return false;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return false;
        }
        for (String namespace : rootTag.knownNamespaces()) {
            if (JSF_CORE_TAGLIB_URI.equals(namespace)) {
                return true;
            }
            if (!JSF_HTML_TAGLIB_URI.equals(namespace)) continue;
            return true;
        }
        return false;
    }
}

