/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.Convertor;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

public class GithubUtil {
    public static final Logger LOG = Logger.getInstance((String)"github");

    public static <T> T runTask(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authHolder", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        return GithubUtil.runTask(project, authHolder, indicator, AuthLevel.LOGGED, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runTask(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull AuthLevel authLevel, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authHolder", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (authLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authLevel", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/github/util/GithubUtil", "runTask"));
        }
        GithubAuthData auth = authHolder.getAuthData();
        try {
            if (!authLevel.accepts(auth)) {
                throw new GithubAuthenticationException("Expected other authentication type: " + authLevel);
            }
            GithubConnection connection = new GithubConnection(auth, true);
            ScheduledFuture<?> future = null;
            try {
                future = GithubUtil.addCancellationListener(indicator, connection);
                Object object = task.convert((Object)connection);
                return (T)object;
            }
            finally {
                connection.close();
                if (future != null) {
                    future.cancel(true);
                }
            }
        }
        catch (GithubTwoFactorAuthenticationException e) {
            GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
            return GithubUtil.runTask(project, authHolder, indicator, authLevel, task);
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, authLevel, auth);
            return GithubUtil.runTask(project, authHolder, indicator, authLevel, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static GithubUserDetailed testConnection(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authHolder", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
        }
        GithubAuthData auth = authHolder.getAuthData();
        GithubConnection connection = new GithubConnection(auth, true);
        ScheduledFuture<?> future = null;
        future = GithubUtil.addCancellationListener(indicator, connection);
        GithubUserDetailed githubUserDetailed = GithubApiUtil.getCurrentUser(connection);
        connection.close();
        if (future != null) {
            future.cancel(true);
        }
        GithubUserDetailed githubUserDetailed2 = githubUserDetailed;
        if (githubUserDetailed2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
        }
        return githubUserDetailed2;
        {
            catch (Throwable throwable) {
                try {
                    connection.close();
                    if (future != null) {
                        future.cancel(true);
                    }
                    throw throwable;
                }
                catch (GithubTwoFactorAuthenticationException e) {
                    GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
                    GithubUserDetailed githubUserDetailed3 = GithubUtil.testConnection(project, authHolder, indicator);
                    if (githubUserDetailed3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "testConnection"));
                    }
                    return githubUserDetailed3;
                }
            }
        }
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull Runnable run) {
        if (run == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "run", "org/jetbrains/plugins/github/util/GithubUtil", "addCancellationListener"));
        }
        ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(run, 1000L, 300L, TimeUnit.MILLISECONDS);
        if (scheduledFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "addCancellationListener"));
        }
        return scheduledFuture;
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull ProgressIndicator indicator, @NotNull GithubConnection connection) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "addCancellationListener"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/util/GithubUtil", "addCancellationListener"));
        }
        ScheduledFuture<?> scheduledFuture = GithubUtil.addCancellationListener(() -> {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$addCancellationListener$0"));
            }
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$addCancellationListener$0"));
            }
            if (indicator.isCanceled()) {
                connection.abort();
            }
        });
        if (scheduledFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "addCancellationListener"));
        }
        return scheduledFuture;
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull ProgressIndicator indicator, @NotNull Thread thread) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "addCancellationListener"));
        }
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "org/jetbrains/plugins/github/util/GithubUtil", "addCancellationListener"));
        }
        ScheduledFuture<?> scheduledFuture = GithubUtil.addCancellationListener(() -> {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$addCancellationListener$1"));
            }
            if (thread == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$addCancellationListener$1"));
            }
            if (indicator.isCanceled()) {
                thread.interrupt();
            }
        });
        if (scheduledFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "addCancellationListener"));
        }
        return scheduledFuture;
    }

    private static void getValidAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull AuthLevel authLevel, @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthData"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authHolder", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthData"));
        }
        if (authLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authLevel", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthData"));
        }
        if (oldAuth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldAuth", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthData"));
        }
        authHolder.runTransaction(oldAuth, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$getValidAuthData$3"));
            }
            if (oldAuth == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldAuth", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$getValidAuthData$3"));
            }
            if (authLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authLevel", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$getValidAuthData$3"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$getValidAuthData$3"));
            }
            GithubAuthData[] authData = new GithubAuthData[1];
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$null$2"));
                }
                if (oldAuth == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldAuth", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$null$2"));
                }
                if (authLevel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authLevel", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$null$2"));
                }
                GithubLoginDialog dialog = new GithubLoginDialog(project, oldAuth, authLevel);
                DialogManager.show((DialogWrapper)dialog);
                if (dialog.isOK()) {
                    authData[0] = dialog.getAuthData();
                    if (!authLevel.isOnetime()) {
                        GithubSettings.getInstance().setAuthData(authData[0], dialog.isSavePasswordSelected());
                    }
                }
            }, indicator.getModalityState());
            if (authData[0] == null) {
                throw new GithubOperationCanceledException("Can't get valid credentials");
            }
            return authData[0];
        });
    }

    private static void getTwoFactorAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "getTwoFactorAuthData"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authHolder", "org/jetbrains/plugins/github/util/GithubUtil", "getTwoFactorAuthData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "getTwoFactorAuthData"));
        }
        if (oldAuth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldAuth", "org/jetbrains/plugins/github/util/GithubUtil", "getTwoFactorAuthData"));
        }
        authHolder.runTransaction(oldAuth, () -> {
            if (authHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authHolder", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$getTwoFactorAuthData$5"));
            }
            if (oldAuth == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldAuth", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$getTwoFactorAuthData$5"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$getTwoFactorAuthData$5"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$getTwoFactorAuthData$5"));
            }
            if (authHolder.getAuthData().getAuthType() != GithubAuthData.AuthType.BASIC) {
                throw new GithubOperationCanceledException("Two factor authentication can be used only with Login/Password");
            }
            GithubApiUtil.askForTwoFactorCodeSMS(new GithubConnection(oldAuth, false));
            Ref codeRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "lambda$null$4"));
                }
                codeRef.set((Object)Messages.showInputDialog((Project)project, (String)"Authentication Code", (String)"Github Two-Factor Authentication", null));
            }, indicator.getModalityState());
            if (codeRef.isNull()) {
                throw new GithubOperationCanceledException("Can't get two factor authentication code");
            }
            GithubSettings settings = GithubSettings.getInstance();
            if (settings.getAuthType() == GithubAuthData.AuthType.BASIC && StringUtil.equalsIgnoreCase((CharSequence)settings.getLogin(), (CharSequence)oldAuth.getBasicAuth().getLogin())) {
                settings.setValidGitAuth(false);
            }
            return oldAuth.copyWithTwoFactorCode((String)codeRef.get());
        });
    }

    @NotNull
    public static GithubAuthDataHolder getValidAuthDataHolderFromConfig(@NotNull Project project, @NotNull AuthLevel authLevel, @NotNull ProgressIndicator indicator) throws IOException {
        GithubAuthDataHolder githubAuthDataHolder;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthDataHolderFromConfig"));
        }
        if (authLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authLevel", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthDataHolderFromConfig"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthDataHolderFromConfig"));
        }
        GithubAuthData auth = GithubAuthData.createFromSettings();
        GithubAuthDataHolder authHolder = new GithubAuthDataHolder(auth);
        try {
            if (!authLevel.accepts(auth)) {
                throw new GithubAuthenticationException("Expected other authentication type: " + authLevel);
            }
            GithubUtil.checkAuthData(project, authHolder, indicator);
            githubAuthDataHolder = authHolder;
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, authLevel, auth);
            GithubAuthDataHolder githubAuthDataHolder2 = authHolder;
            if (githubAuthDataHolder2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthDataHolderFromConfig"));
            }
            return githubAuthDataHolder2;
        }
        if (githubAuthDataHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "getValidAuthDataHolderFromConfig"));
        }
        return githubAuthDataHolder;
    }

    @NotNull
    public static GithubUserDetailed checkAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "checkAuthData"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authHolder", "org/jetbrains/plugins/github/util/GithubUtil", "checkAuthData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "checkAuthData"));
        }
        GithubAuthData auth = authHolder.getAuthData();
        if (StringUtil.isEmptyOrSpaces((String)auth.getHost())) {
            throw new GithubAuthenticationException("Target host not defined");
        }
        try {
            new URI(auth.getHost());
        }
        catch (URISyntaxException e) {
            throw new GithubAuthenticationException("Invalid host URL");
        }
        switch (auth.getAuthType()) {
            case BASIC: {
                GithubAuthData.BasicAuth basicAuth = auth.getBasicAuth();
                assert (basicAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)basicAuth.getLogin()) && !StringUtil.isEmptyOrSpaces((String)basicAuth.getPassword())) break;
                throw new GithubAuthenticationException("Empty login or password");
            }
            case TOKEN: {
                GithubAuthData.TokenAuth tokenAuth = auth.getTokenAuth();
                assert (tokenAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)tokenAuth.getToken())) break;
                throw new GithubAuthenticationException("Empty token");
            }
            case ANONYMOUS: {
                throw new GithubAuthenticationException("Anonymous connection not allowed");
            }
        }
        GithubUserDetailed githubUserDetailed = GithubUtil.testConnection(project, authHolder, indicator);
        if (githubUserDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "checkAuthData"));
        }
        return githubUserDetailed;
    }

    public static <T> T computeValueInModalIO(@NotNull Project project, @NotNull String caption, final @NotNull ThrowableConvertor<ProgressIndicator, T, IOException> task) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModalIO"));
        }
        if (caption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModalIO"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModalIO"));
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, IOException>(project, caption, true){

            protected T compute(@NotNull ProgressIndicator indicator) throws IOException {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil$1", "compute"));
                }
                return task.convert((Object)indicator);
            }
        });
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, @NotNull Convertor<ProgressIndicator, T> task) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (caption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        return GithubUtil.computeValueInModal(project, caption, true, task);
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, boolean canBeCancelled, final @NotNull Convertor<ProgressIndicator, T> task) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (caption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, RuntimeException>(project, caption, canBeCancelled){

            protected T compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil$2", "compute"));
                }
                return task.convert((Object)indicator);
            }
        });
    }

    public static void computeValueInModal(@NotNull Project project, @NotNull String caption, boolean canBeCancelled, final @NotNull Consumer<ProgressIndicator> task) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (caption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/github/util/GithubUtil", "computeValueInModal"));
        }
        ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Void, RuntimeException>(project, caption, canBeCancelled){

            protected Void compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil$3", "compute"));
                }
                task.consume((Object)indicator);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInterruptable(@NotNull ProgressIndicator indicator, @NotNull ThrowableComputable<T, IOException> task) throws IOException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil", "runInterruptable"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/github/util/GithubUtil", "runInterruptable"));
        }
        ScheduledFuture<?> future = null;
        try {
            Thread thread = Thread.currentThread();
            future = GithubUtil.addCancellationListener(indicator, thread);
            Object object = task.compute();
            return (T)object;
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            Thread.interrupted();
        }
    }

    @Nullable
    public static String findGithubRemoteUrl(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/util/GithubUtil", "findGithubRemoteUrl"));
        }
        Pair<GitRemote, String> remote = GithubUtil.findGithubRemote(repository);
        if (remote == null) {
            return null;
        }
        return (String)remote.getSecond();
    }

    @Nullable
    public static Pair<GitRemote, String> findGithubRemote(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/util/GithubUtil", "findGithubRemote"));
        }
        Pair githubRemote = null;
        block0: for (GitRemote gitRemote : repository.getRemotes()) {
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                String remoteName = gitRemote.getName();
                if ("github".equals(remoteName) || "origin".equals(remoteName)) {
                    return Pair.create((Object)gitRemote, (Object)remoteUrl);
                }
                if (githubRemote != null) continue block0;
                githubRemote = Pair.create((Object)gitRemote, (Object)remoteUrl);
                continue block0;
            }
        }
        return githubRemote;
    }

    @Nullable
    public static String findUpstreamRemote(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/util/GithubUtil", "findUpstreamRemote"));
        }
        for (GitRemote gitRemote : repository.getRemotes()) {
            String remoteName = gitRemote.getName();
            if (!"upstream".equals(remoteName)) continue;
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                return remoteUrl;
            }
            return gitRemote.getFirstUrl();
        }
        return null;
    }

    public static boolean testGitExecutable(Project project) {
        GitVersion version;
        GitVcsApplicationSettings settings = GitVcsApplicationSettings.getInstance();
        String executable = settings.getPathToGit();
        try {
            version = GitVersion.identifyVersion((String)executable);
        }
        catch (Exception e) {
            GithubNotifications.showErrorDialog(project, GitBundle.getString((String)"find.git.error.title"), e);
            return false;
        }
        if (!version.isSupported()) {
            GithubNotifications.showWarningDialog(project, GitBundle.message((String)"find.git.unsupported.message", (Object[])new Object[]{version.toString(), GitVersion.MIN}), GitBundle.getString((String)"find.git.success.title"));
            return false;
        }
        return true;
    }

    public static boolean isRepositoryOnGitHub(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/util/GithubUtil", "isRepositoryOnGitHub"));
        }
        return GithubUtil.findGithubRemoteUrl(repository) != null;
    }

    @NotNull
    public static String getErrorTextFromException(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/util/GithubUtil", "getErrorTextFromException"));
        }
        if (e instanceof UnknownHostException) {
            String string = "Unknown host: " + e.getMessage();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "getErrorTextFromException"));
            }
            return string;
        }
        String string = StringUtil.notNullize((String)e.getMessage(), (String)"Unknown error");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUtil", "getErrorTextFromException"));
        }
        return string;
    }

    @Nullable
    public static GitRepository getGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        GitRepository repository;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "getGitRepository"));
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        List repositories = manager.getRepositories();
        if (repositories.size() == 0) {
            return null;
        }
        if (repositories.size() == 1) {
            return (GitRepository)repositories.get(0);
        }
        if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
            return repository;
        }
        return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
    }

    public static boolean addGithubRemote(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remote, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubUtil", "addGithubRemote"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/util/GithubUtil", "addGithubRemote"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "org/jetbrains/plugins/github/util/GithubUtil", "addGithubRemote"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/util/GithubUtil", "addGithubRemote"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, repository.getRoot(), GitCommand.REMOTE);
        handler.setSilent(true);
        try {
            handler.addParameters(new String[]{"add", remote, url});
            handler.run();
            if (handler.getExitCode() != 0) {
                GithubNotifications.showError(project, "Can't add remote", "Failed to add GitHub remote: '" + url + "'. " + handler.getStderr());
                return false;
            }
            repository.update();
            return true;
        }
        catch (VcsException e) {
            GithubNotifications.showError(project, "Can't add remote", (Exception)((Object)e));
            return false;
        }
    }

    public static Couple<String> getGithubLikeFormattedDescriptionMessage(String commitMessage) {
        String description;
        String subject;
        String message;
        String string = message = commitMessage == null ? "" : commitMessage.trim();
        if (message.isEmpty()) {
            return Couple.of((Object)"", (Object)"");
        }
        int firstLineEnd = message.indexOf("\n");
        if (firstLineEnd > -1) {
            subject = message.substring(0, firstLineEnd).trim();
            description = message.substring(firstLineEnd + 1).trim();
        } else {
            subject = message;
            description = "";
        }
        return Couple.of((Object)subject, (Object)description);
    }
}

