/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public abstract class ClassBodyCodegen
extends MemberCodegen<KtPureClassOrObject> {
    @NotNull
    public final KtPureClassOrObject myClass;
    @NotNull
    public final OwnerKind kind;
    @NotNull
    public final ClassDescriptor descriptor;

    protected ClassBodyCodegen(@NotNull KtPureClassOrObject myClass, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen) {
        if (myClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myClass", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        super(state, parentCodegen, context, myClass, v);
        this.myClass = myClass;
        this.kind = context.getContextKind();
        this.descriptor = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(myClass, this.bindingContext);
    }

    @Override
    protected void generateBody() {
        ArrayList<KtObjectDeclaration> companions = new ArrayList<KtObjectDeclaration>();
        if (this.kind != OwnerKind.DEFAULT_IMPLS) {
            for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
                if (!ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
                if (ktDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)ktDeclaration).isCompanion()) {
                    companions.add((KtObjectDeclaration)ktDeclaration);
                    CodegenUtilKt.populateCompanionBackingFieldNamesToOuterContextIfNeeded((KtObjectDeclaration)ktDeclaration, this.context, this.state);
                    continue;
                }
                this.generateDeclaration(ktDeclaration);
            }
        }
        for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
            if (ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
            this.generateDeclaration(ktDeclaration);
        }
        boolean generateNonClassMembers = this.shouldGenerateNonClassMembers();
        if (generateNonClassMembers) {
            this.generatePrimaryConstructorProperties();
            this.generateConstructors();
            this.generateDefaultImplsIfNeeded();
        }
        for (KtObjectDeclaration companion : companions) {
            this.genClassOrObject(companion);
        }
        ClassDescriptor classDescriptor = this.descriptor.getCompanionObjectDescriptor();
        if (classDescriptor instanceof SyntheticClassOrObjectDescriptor) {
            this.genSyntheticClassOrObject((SyntheticClassOrObjectDescriptor)classDescriptor);
        }
        if (generateNonClassMembers) {
            this.generateBridges();
        }
    }

    private void generateBridges() {
        if (DescriptorUtils.isInterface(this.descriptor)) {
            return;
        }
        for (DeclarationDescriptor memberDescriptor : DescriptorUtils.getAllDescriptors(this.descriptor.getDefaultType().getMemberScope())) {
            PropertySetterDescriptor setter;
            CallableMemberDescriptor member;
            if (!(memberDescriptor instanceof CallableMemberDescriptor) || (member = (CallableMemberDescriptor)memberDescriptor).getKind().isReal() || ImplKt.findInterfaceImplementation(member) != null) continue;
            if (member instanceof FunctionDescriptor) {
                this.functionCodegen.generateBridges((FunctionDescriptor)member);
                continue;
            }
            if (!(member instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getter = ((PropertyDescriptor)member).getGetter();
            if (getter != null) {
                this.functionCodegen.generateBridges(getter);
            }
            if ((setter = ((PropertyDescriptor)member).getSetter()) == null) continue;
            this.functionCodegen.generateBridges(setter);
        }
    }

    private boolean shouldGenerateNonClassMembers() {
        return !(this.myClass instanceof KtClassOrObject) || this.state.getGenerateDeclaredClassFilter().shouldGenerateClassMembers((KtClassOrObject)this.myClass);
    }

    protected void generateConstructors() {
    }

    protected void generateDefaultImplsIfNeeded() {
    }

    private static boolean shouldProcessFirst(KtDeclaration declaration2) {
        return !(declaration2 instanceof KtProperty) && !(declaration2 instanceof KtNamedFunction);
    }

    protected void generateDeclaration(KtDeclaration declaration2) {
        if (declaration2 instanceof KtProperty || declaration2 instanceof KtNamedFunction || declaration2 instanceof KtTypeAlias) {
            if (this.shouldGenerateNonClassMembers()) {
                this.genSimpleMember(declaration2);
            }
        } else if (declaration2 instanceof KtClassOrObject) {
            if (declaration2 instanceof KtEnumEntry && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration2)) {
                return;
            }
            this.genClassOrObject((KtClassOrObject)declaration2);
        }
    }

    private void generatePrimaryConstructorProperties() {
        boolean isAnnotation = this.descriptor.getKind() == ClassKind.ANNOTATION_CLASS;
        for (KtParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (!p.hasValOrVar() || (propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (!isAnnotation) {
                this.propertyCodegen.generatePrimaryConstructorProperty(p, propertyDescriptor);
                continue;
            }
            this.propertyCodegen.generateConstructorPropertyAsMethodForAnnotationClass(p, propertyDescriptor);
        }
    }

    @NotNull
    protected List<KtParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof KtClass) {
            List<KtParameter> list2 = this.myClass.getPrimaryConstructorParameters();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "getPrimaryConstructorParameters"));
            }
            return list2;
        }
        List<KtParameter> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "getPrimaryConstructorParameters"));
        }
        return list3;
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return InnerClassConsumer.Companion.classForInnerClassRecord(this.descriptor, false);
    }
}

