/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedValueDescriptor;

public class RedundantBoxedValuesCollection
implements Iterable<BoxedValueDescriptor> {
    private final Set<BoxedValueDescriptor> safeToDeleteValues = new HashSet<BoxedValueDescriptor>();

    public void add(@NotNull BoxedValueDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "add"));
        }
        this.safeToDeleteValues.add(descriptor2);
    }

    public void remove(@NotNull BoxedValueDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "remove"));
        }
        if (this.safeToDeleteValues.contains(descriptor2)) {
            this.safeToDeleteValues.remove(descriptor2);
            descriptor2.markAsUnsafeToRemove();
            for (BoxedValueDescriptor mergedValueDescriptor : descriptor2.getMergedWith()) {
                this.remove(mergedValueDescriptor);
            }
        }
    }

    public void merge(@NotNull BoxedValueDescriptor v, @NotNull BoxedValueDescriptor w) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "merge"));
        }
        if (w == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "merge"));
        }
        v.addMergedWith(w);
        w.addMergedWith(v);
        if (v.isSafeToRemove() && !w.isSafeToRemove()) {
            this.remove(v);
        }
        if (!v.isSafeToRemove() && w.isSafeToRemove()) {
            this.remove(w);
        }
    }

    public boolean isEmpty() {
        return this.safeToDeleteValues.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<BoxedValueDescriptor> iterator() {
        Iterator<BoxedValueDescriptor> iterator2 = this.safeToDeleteValues.iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "iterator"));
        }
        return iterator2;
    }
}

