/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.utils.StringsKt;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    @NotNull
    public static List<String> convertArgumentsToStringList(@NotNull CommonToolArguments arguments2) throws InstantiationException, IllegalAccessException {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        ArgumentUtils.convertArgumentsToStringList(arguments2, (CommonToolArguments)arguments2.getClass().newInstance(), arguments2.getClass(), result2);
        result2.addAll(arguments2.freeArgs);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        return arrayList;
    }

    private static void convertArgumentsToStringList(@NotNull CommonToolArguments arguments2, @NotNull CommonToolArguments defaultArguments, @NotNull Class<?> clazz, @NotNull List<String> result2) throws IllegalAccessException, InstantiationException {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (defaultArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultArguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        for (Field field2 : clazz.getDeclaredFields()) {
            Object defaultValue;
            Object value2;
            Argument argument2 = field2.getAnnotation(Argument.class);
            if (argument2 == null) continue;
            try {
                value2 = field2.get(arguments2);
                defaultValue = field2.get(defaultArguments);
            }
            catch (IllegalAccessException ignored) {
                continue;
            }
            if (value2 == null || Objects.equals(value2, defaultValue)) continue;
            Class<?> fieldType = field2.getType();
            if (fieldType.isArray()) {
                Object[] values = (Object[])value2;
                if (values.length == 0) continue;
                value2 = StringsKt.join(Arrays.asList(values), ",");
            }
            result2.add(argument2.value());
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) continue;
            if (ParseCommandLineArgumentsKt.isAdvanced(argument2)) {
                result2.set(result2.size() - 1, argument2.value() + "=" + value2.toString());
                continue;
            }
            result2.add(value2.toString());
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            ArgumentUtils.convertArgumentsToStringList(arguments2, defaultArguments, superClazz, result2);
        }
    }
}

