/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt$WhenMappings;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.OverridingUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u001f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0000\u0010\f*\u00020\r*\u0002H\f\u00a2\u0006\u0002\u0010\u000e\u001a\u001f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0000\u0010\f*\u00020\r*\u0002H\f\u00a2\u0006\u0002\u0010\u000e\u001a,\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0005\u001a6\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u001f\u00a8\u0006 "}, d2={"compareDescriptors", "", "project", "Lcom/intellij/openapi/project/Project;", "currentDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "originalDescriptor", "compareDescriptorsText", "d1", "d2", "getDeepestSuperDeclarations", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Ljava/util/Collection;", "getDirectlyOverriddenDeclarations", "isVisible", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "context", "Lcom/intellij/psi/PsiElement;", "receiverExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "from", "resolutionScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "toKeywordToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "idea-core"})
public final class DescriptorUtilsKt {
    public static final boolean isVisible(@NotNull DeclarationDescriptorWithVisibility $receiver, @NotNull DeclarationDescriptor from) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return DescriptorUtilsKt.isVisible$default($receiver, from, null, null, null, 12, null);
    }

    public static final boolean isVisible(@NotNull DeclarationDescriptorWithVisibility $receiver, @NotNull PsiElement context, @Nullable KtExpression receiverExpression, @NotNull BindingContext bindingContext2, @NotNull ResolutionFacade resolutionFacade) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade, (String)"resolutionFacade");
        LexicalScope resolutionScope = ScopeUtils.getResolutionScope(context, bindingContext2, resolutionFacade);
        DeclarationDescriptor from = resolutionScope.getOwnerDescriptor();
        return DescriptorUtilsKt.isVisible($receiver, from, receiverExpression, bindingContext2, resolutionScope);
    }

    private static final boolean isVisible(@NotNull DeclarationDescriptorWithVisibility $receiver, DeclarationDescriptor from, KtExpression receiverExpression, BindingContext bindingContext2, LexicalScope resolutionScope) {
        boolean bl;
        block5: {
            if (Visibilities.isVisibleWithAnyReceiver($receiver, from)) {
                return true;
            }
            if (bindingContext2 == null || resolutionScope == null) {
                return false;
            }
            if (receiverExpression != null && !org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt.isExtension($receiver)) {
                KotlinType receiverType2;
                KotlinType kotlinType = bindingContext2.getType(receiverExpression);
                if (kotlinType == null) {
                    return false;
                }
                KotlinType kotlinType2 = receiverType2 = kotlinType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"receiverType");
                ExpressionReceiver explicitReceiver = ExpressionReceiver.Companion.create(receiverExpression, kotlinType2, bindingContext2);
                return Visibilities.isVisible(explicitReceiver, $receiver, from);
            }
            Iterable $receiver$iv = ScopeUtilsKt.getImplicitReceiversHierarchy(resolutionScope);
            for (Object element$iv : $receiver$iv) {
                ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv;
                if (!Visibilities.isVisible(it.getValue(), $receiver, from)) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    static /* bridge */ /* synthetic */ boolean isVisible$default(DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility, DeclarationDescriptor declarationDescriptor, KtExpression ktExpression, BindingContext bindingContext2, LexicalScope lexicalScope, int n, Object object) {
        if ((n & 4) != 0) {
            bindingContext2 = null;
        }
        if ((n & 8) != 0) {
            lexicalScope = null;
        }
        return DescriptorUtilsKt.isVisible(declarationDescriptorWithVisibility, declarationDescriptor, ktExpression, bindingContext2, lexicalScope);
    }

    private static final boolean compareDescriptorsText(Project project, DeclarationDescriptor d1, DeclarationDescriptor d2) {
        Collection collection;
        Collection declarations2;
        String renderedD2;
        if (Intrinsics.areEqual((Object)d1, (Object)d2)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)d1.getName(), (Object)d2.getName()) ^ true) {
            return false;
        }
        String renderedD1 = IdeDescriptorRenderers.SOURCE_CODE.render(d1);
        if (Intrinsics.areEqual((Object)renderedD1, (Object)(renderedD2 = IdeDescriptorRenderers.SOURCE_CODE.render(d2)))) {
            return true;
        }
        Collection declarations1 = DescriptorToSourceUtilsIde.getAllDeclarations$default(DescriptorToSourceUtilsIde.INSTANCE, project, d1, null, 4, null);
        return Intrinsics.areEqual((Object)declarations1, (Object)(declarations2 = DescriptorToSourceUtilsIde.getAllDeclarations$default(DescriptorToSourceUtilsIde.INSTANCE, project, d2, null, 4, null))) && !(collection = declarations1).isEmpty();
    }

    public static final boolean compareDescriptors(@NotNull Project project, @Nullable DeclarationDescriptor currentDescriptor2, @Nullable DeclarationDescriptor originalDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)currentDescriptor2, (Object)originalDescriptor)) {
            return true;
        }
        if (currentDescriptor2 == null || originalDescriptor == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)currentDescriptor2.getName(), (Object)originalDescriptor.getName()) ^ true) {
            return false;
        }
        if (originalDescriptor instanceof SyntheticJavaPropertyDescriptor && currentDescriptor2 instanceof SyntheticJavaPropertyDescriptor) {
            return DescriptorUtilsKt.compareDescriptors(project, ((SyntheticJavaPropertyDescriptor)currentDescriptor2).getGetMethod(), ((SyntheticJavaPropertyDescriptor)originalDescriptor).getGetMethod());
        }
        if (DescriptorUtilsKt.compareDescriptorsText(project, currentDescriptor2, originalDescriptor)) {
            return true;
        }
        if (originalDescriptor instanceof CallableDescriptor && currentDescriptor2 instanceof CallableDescriptor) {
            boolean bl;
            block8: {
                Set<CallableDescriptor> overriddenOriginalDescriptor = OverridingUtilsKt.findOriginalTopMostOverriddenDescriptors((CallableDescriptor)originalDescriptor);
                Set<CallableDescriptor> overriddenCurrentDescriptor = OverridingUtilsKt.findOriginalTopMostOverriddenDescriptors((CallableDescriptor)currentDescriptor2);
                if (overriddenOriginalDescriptor.size() != overriddenCurrentDescriptor.size()) {
                    return false;
                }
                Iterable $receiver$iv = CollectionsKt.zip((Iterable)overriddenCurrentDescriptor, (Iterable)overriddenOriginalDescriptor);
                for (Object element$iv : $receiver$iv) {
                    Pair it = (Pair)element$iv;
                    if (DescriptorUtilsKt.compareDescriptorsText(project, (DeclarationDescriptor)it.getFirst(), (DeclarationDescriptor)it.getSecond())) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            return bl;
        }
        return false;
    }

    @NotNull
    public static final KtModifierKeywordToken toKeywordToken(@NotNull Visibility $receiver) {
        Visibility normalized;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Visibility visibility = normalized = $receiver.normalize();
        if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PUBLIC)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PUBLIC_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PUBLIC_KEYWORD");
            return ktModifierKeywordToken;
        }
        if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PROTECTED)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PROTECTED_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PROTECTED_KEYWORD");
            return ktModifierKeywordToken;
        }
        if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.INTERNAL)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.INTERNAL_KEYWORD");
            return ktModifierKeywordToken;
        }
        if (Visibilities.isPrivate(normalized)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PRIVATE_KEYWORD");
            return ktModifierKeywordToken;
        }
        String string = "Unexpected visibility '" + normalized + '\'';
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public static final <D extends CallableMemberDescriptor> Collection<D> getDirectlyOverriddenDeclarations(@NotNull D $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        LinkedHashSet<CallableMemberDescriptor> result2 = new LinkedHashSet<CallableMemberDescriptor>();
        for (CallableMemberDescriptor callableMemberDescriptor : $receiver.getOverriddenDescriptors()) {
            switch (DescriptorUtilsKt$WhenMappings.$EnumSwitchMapping$0[callableMemberDescriptor.getKind().ordinal()]) {
                case 1: {
                    CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                    if (callableMemberDescriptor2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type D");
                    }
                    result2.add(callableMemberDescriptor2);
                    break;
                }
                case 2: 
                case 3: {
                    CallableMemberDescriptor callableMemberDescriptor3 = callableMemberDescriptor;
                    if (callableMemberDescriptor3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type D");
                    }
                    result2.addAll(DescriptorUtilsKt.getDirectlyOverriddenDeclarations(callableMemberDescriptor3));
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)callableMemberDescriptor.getKind()) + ": " + callableMemberDescriptor)));
                }
            }
        }
        Set set2 = OverridingUtil.filterOutOverridden((Set)result2);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"OverridingUtil.filterOutOverridden(result)");
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <D extends CallableMemberDescriptor> Collection<D> getDeepestSuperDeclarations(@NotNull D $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Set<D> overriddenDeclarations = DescriptorUtils.getAllOverriddenDeclarations($receiver);
        if (overriddenDeclarations.isEmpty()) {
            return SetsKt.setOf($receiver);
        }
        Iterable iterable = $receiver$iv = (Iterable)overriddenDeclarations;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor p1 = (CallableMemberDescriptor)element$iv$iv;
            if (DescriptorUtils.isOverride(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

