/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.util.containers.ConcurrentWeakFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.BinaryCacheKey;
import org.jetbrains.kotlin.idea.debugger.BytecodeDebugInfo;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SmapData;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J\u0016\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/WeakBytecodeDebugInfoStorage;", "Lcom/intellij/util/containers/ConcurrentWeakFactoryMap;", "Lorg/jetbrains/kotlin/idea/debugger/BinaryCacheKey;", "Lorg/jetbrains/kotlin/idea/debugger/BytecodeDebugInfo;", "()V", "create", "key", "createMap", "", "idea"})
public final class WeakBytecodeDebugInfoStorage
extends ConcurrentWeakFactoryMap<BinaryCacheKey, BytecodeDebugInfo> {
    @Nullable
    protected BytecodeDebugInfo create(@NotNull BinaryCacheKey key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        byte[] byArray = NoStrataPositionManagerHelperKt.access$readClassFileImpl(key.getProject(), key.getJvmName(), key.getFile());
        if (byArray == null) {
            return null;
        }
        byte[] bytes2 = byArray;
        SmapData smapData = SmapUtilKt.readDebugInfo(bytes2);
        Map lineNumberMapping = NoStrataPositionManagerHelperKt.access$readLineNumberTableMapping(bytes2);
        return new BytecodeDebugInfo(smapData, lineNumberMapping);
    }

    @NotNull
    protected Map<BinaryCacheKey, BytecodeDebugInfo> createMap() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026rentWeakKeyWeakValueMap()");
        return concurrentMap;
    }
}

