/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;

public class JavaRuntimePresentationProvider
extends LibraryPresentationProvider<LibraryVersionProperties> {
    public static JavaRuntimePresentationProvider getInstance() {
        return (JavaRuntimePresentationProvider)((Object)LibraryPresentationProvider.EP_NAME.findExtension(JavaRuntimePresentationProvider.class));
    }

    protected JavaRuntimePresentationProvider() {
        super(JavaRuntimeLibraryDescription.Companion.getKOTLIN_JAVA_RUNTIME_KIND());
    }

    @Nullable
    public Icon getIcon(@Nullable LibraryVersionProperties properties2) {
        return KotlinIcons.SMALL_LOGO;
    }

    @Nullable
    public LibraryVersionProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/JavaRuntimePresentationProvider", "detect"));
        }
        String version = JavaRuntimeDetectionUtil.getJavaRuntimeVersion(classesRoots);
        return version == null ? null : new LibraryVersionProperties(version);
    }
}

