/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeIntention;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantExplicitTypeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "idea"})
public final class RedundantExplicitTypeInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitProperty(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                super.visitProperty(property2);
                if (!property2.isLocal()) {
                    return;
                }
                KtTypeReference ktTypeReference = property2.getTypeReference();
                if (ktTypeReference == null) {
                    return;
                }
                KtTypeReference typeReference = ktTypeReference;
                KtExpression ktExpression = property2.getInitializer();
                if (ktExpression == null) {
                    return;
                }
                KtExpression initializer2 = ktExpression;
                KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze(property2, BodyResolveMode.PARTIAL).get(BindingContext.TYPE, typeReference);
                if (kotlinType == null) {
                    return;
                }
                KotlinType type2 = kotlinType;
                KtExpression ktExpression2 = initializer2;
                if (ktExpression2 instanceof KtConstantExpression) {
                    IElementType iElementType = ((KtConstantExpression)initializer2).getNode().getElementType();
                    if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.BOOLEAN_CONSTANT))) {
                        if (!KotlinBuiltIns.isBoolean(type2)) {
                            return;
                        }
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.INTEGER_CONSTANT))) {
                        if (StringsKt.endsWith$default((String)((KtConstantExpression)initializer2).getText(), (String)"L", (boolean)false, (int)2, null) ? !KotlinBuiltIns.isLong(type2) : !KotlinBuiltIns.isInt(type2)) {
                            return;
                        }
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.FLOAT_CONSTANT))) {
                        if (StringsKt.endsWith$default((String)((KtConstantExpression)initializer2).getText(), (String)"f", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)((KtConstantExpression)initializer2).getText(), (String)"F", (boolean)false, (int)2, null) ? !KotlinBuiltIns.isFloat(type2) : !KotlinBuiltIns.isDouble(type2)) {
                            return;
                        }
                    } else {
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.CHARACTER_CONSTANT))) return;
                        if (!KotlinBuiltIns.isChar(type2)) {
                            return;
                        }
                    }
                } else if (ktExpression2 instanceof KtStringTemplateExpression) {
                    if (!KotlinBuiltIns.isString(type2)) {
                        return;
                    }
                } else if (ktExpression2 instanceof KtNameReferenceExpression) {
                    if (Intrinsics.areEqual((Object)typeReference.getText(), (Object)((KtNameReferenceExpression)initializer2).getReferencedName()) ^ true) {
                        return;
                    }
                } else {
                    if (!(ktExpression2 instanceof KtCallExpression)) return;
                    KtExpression ktExpression3 = ((KtCallExpression)initializer2).getCalleeExpression();
                    if (Intrinsics.areEqual((Object)typeReference.getText(), (Object)(ktExpression3 != null ? ktExpression3.getText() : null)) ^ true) {
                        return;
                    }
                }
                this.$holder.registerProblem((PsiElement)typeReference, "Explicitly given type is redundant here", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new RemoveExplicitTypeIntention(), (PsiFile)property2.getContainingKtFile())});
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

