/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J!\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceExplicitFunctionLiteralParamWithItIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "()V", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "startInWriteAction", "targetFunctionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "caretOffset", "", "usesName", "name", "ParamRenamingProcessor", "idea"})
public final class ReplaceExplicitFunctionLiteralParamWithItIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Replace explicit lambda parameter with 'it'";
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        void result$iv$iv$iv;
        void $receiver$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtFunctionLiteral ktFunctionLiteral = this.targetFunctionLiteral(element2, editor.getCaretModel().getOffset());
        if (ktFunctionLiteral == null) {
            return false;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull(functionLiteral.getValueParameters());
        if (ktParameter == null) {
            return false;
        }
        KtParameter parameter = ktParameter;
        if (parameter.getTypeReference() != null) {
            return false;
        }
        if (parameter.getDestructuringDeclaration() != null) {
            return false;
        }
        PsiElement psiElement2 = functionLiteral;
        Function1 predicate$iv = (Function1)new Function1<KtFunctionLiteral, Boolean>(this, element2){
            final /* synthetic */ ReplaceExplicitFunctionLiteralParamWithItIntention this$0;
            final /* synthetic */ PsiElement $element;

            public final boolean invoke(@NotNull KtFunctionLiteral literal) {
                Intrinsics.checkParameterIsNotNull((Object)literal, (String)"literal");
                String string = this.$element.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.text");
                return ReplaceExplicitFunctionLiteralParamWithItIntention.access$usesName(this.this$0, literal, string) && (!literal.hasParameterSpecification() || ReplaceExplicitFunctionLiteralParamWithItIntention.access$usesName(this.this$0, literal, "it"));
            }
            {
                this.this$0 = replaceExplicitFunctionLiteralParamWithItIntention;
                this.$element = psiElement2;
                super(1);
            }
        };
        void $receiver$iv$iv$iv = $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(PsiElement element2) {
                if (element2 instanceof KtFunctionLiteral && ((Boolean)this.$predicate.invoke((Object)element2)).booleanValue()) {
                    this.$result.element = element2;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element2;
                super.visitElement(element2);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element != null) {
            return false;
        }
        this.setText("Replace explicit parameter '" + parameter.getName() + "' with 'it'");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean usesName(@NotNull KtFunctionLiteral $receiver, String name2) {
        void result$iv$iv$iv;
        void $receiver$iv;
        void $receiver$iv$iv;
        PsiElement psiElement2 = $receiver;
        Function1 predicate$iv = (Function1)new Function1<KtSimpleNameExpression, Boolean>(name2){
            final /* synthetic */ String $name;

            public final boolean invoke(@NotNull KtSimpleNameExpression nameExpr) {
                Intrinsics.checkParameterIsNotNull((Object)nameExpr, (String)"nameExpr");
                return Intrinsics.areEqual((Object)nameExpr.getReferencedName(), (Object)this.$name);
            }
            {
                this.$name = string;
                super(1);
            }
        };
        void $receiver$iv$iv$iv = $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(PsiElement element2) {
                if (element2 instanceof KtSimpleNameExpression && ((Boolean)this.$predicate.invoke((Object)element2)).booleanValue()) {
                    this.$result.element = element2;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element2;
                super.visitElement(element2);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        int caretOffset = editor.getCaretModel().getOffset();
        KtFunctionLiteral ktFunctionLiteral = this.targetFunctionLiteral(element2, editor.getCaretModel().getOffset());
        if (ktFunctionLiteral == null) {
            Intrinsics.throwNpe();
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        KtParameterList ktParameterList = functionLiteral.getValueParameterList();
        if (ktParameterList == null) {
            Intrinsics.throwNpe();
        }
        boolean cursorInParameterList = ktParameterList.getTextRange().containsOffset(caretOffset);
        new ParamRenamingProcessor(editor, functionLiteral, cursorInParameterList).run();
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunctionLiteral targetFunctionLiteral(PsiElement element2, int caretOffset) {
        void $receiver$iv;
        void $receiver$iv2;
        PsiElement psiElement2 = element2;
        boolean strict$iv = true;
        KtNameReferenceExpression expression2 = (KtNameReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtNameReferenceExpression.class, (boolean)strict$iv);
        if (expression2 != null) {
            Object object = CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors(expression2));
            if (!(object instanceof ParameterDescriptor)) {
                object = null;
            }
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
            if (parameterDescriptor == null) {
                return null;
            }
            ParameterDescriptor target = parameterDescriptor;
            DeclarationDescriptor declarationDescriptor = target.getContainingDeclaration();
            if (!(declarationDescriptor instanceof AnonymousFunctionDescriptor)) {
                declarationDescriptor = null;
            }
            AnonymousFunctionDescriptor anonymousFunctionDescriptor = (AnonymousFunctionDescriptor)declarationDescriptor;
            if (anonymousFunctionDescriptor == null) {
                return null;
            }
            AnonymousFunctionDescriptor functionDescriptor2 = anonymousFunctionDescriptor;
            PsiElement psiElement3 = DescriptorToSourceUtils.descriptorToDeclaration(functionDescriptor2);
            if (!(psiElement3 instanceof KtFunctionLiteral)) {
                psiElement3 = null;
            }
            return (KtFunctionLiteral)psiElement3;
        }
        PsiElement functionDescriptor2 = element2;
        boolean strict$iv2 = true;
        KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtFunctionLiteral.class, (boolean)strict$iv2);
        if (ktFunctionLiteral == null) {
            return null;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        PsiElement psiElement4 = functionLiteral.getArrow();
        if (psiElement4 == null) {
            return null;
        }
        PsiElement arrow = psiElement4;
        if (caretOffset > PsiUtilsKt.getEndOffset(arrow)) {
            return null;
        }
        return functionLiteral;
    }

    public static final /* synthetic */ boolean access$usesName(ReplaceExplicitFunctionLiteralParamWithItIntention $this, @NotNull KtFunctionLiteral $receiver, @NotNull String name2) {
        return $this.usesName($receiver, name2);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceExplicitFunctionLiteralParamWithItIntention$ParamRenamingProcessor;", "Lcom/intellij/refactoring/rename/RenameProcessor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "cursorWasInParameterList", "", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;Z)V", "getCursorWasInParameterList", "()Z", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFunctionLiteral", "()Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "performRefactoring", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)V", "idea"})
    private static final class ParamRenamingProcessor
    extends RenameProcessor {
        @NotNull
        private final Editor editor;
        @NotNull
        private final KtFunctionLiteral functionLiteral;
        private final boolean cursorWasInParameterList;

        public void performRefactoring(@NotNull UsageInfo[] usages2) {
            Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
            super.performRefactoring(usages2);
            PsiElement psiElement2 = (PsiElement)this.functionLiteral.getValueParameterList();
            PsiElement psiElement3 = this.functionLiteral.getArrow();
            if (psiElement3 == null) {
                Intrinsics.throwNpe();
            }
            this.functionLiteral.deleteChildRange(psiElement2, psiElement3);
            if (this.cursorWasInParameterList) {
                CaretModel caretModel = this.editor.getCaretModel();
                KtBlockExpression ktBlockExpression = this.functionLiteral.getBodyExpression();
                if (ktBlockExpression == null) {
                    Intrinsics.throwNpe();
                }
                caretModel.moveToOffset(ktBlockExpression.getTextOffset());
            }
            Project project = this.functionLiteral.getProject();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(this.editor.getDocument());
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(this.functionLiteral.getContainingFile(), this.functionLiteral.getTextRange());
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final KtFunctionLiteral getFunctionLiteral() {
            return this.functionLiteral;
        }

        public final boolean getCursorWasInParameterList() {
            return this.cursorWasInParameterList;
        }

        public ParamRenamingProcessor(@NotNull Editor editor, @NotNull KtFunctionLiteral functionLiteral, boolean cursorWasInParameterList) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)functionLiteral, (String)"functionLiteral");
            super(editor.getProject(), (PsiElement)CollectionsKt.single(functionLiteral.getValueParameters()), "it", false, false);
            this.editor = editor;
            this.functionLiteral = functionLiteral;
            this.cursorWasInParameterList = cursorWasInParameterList;
        }
    }
}

