/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenVersionComparable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "createFixes", "", "Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection$SetVersionQuickFix;", "project", "Lorg/jetbrains/idea/maven/project/MavenProject;", "versionElement", "Lcom/intellij/util/xml/GenericDomValue;", "versions", "", "SetVersionQuickFix", "idea-maven"})
public final class DifferentMavenStdlibVersionInspection
extends DomElementsInspection<MavenDomProjectModel> {
    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        SetVersionQuickFix[] setVersionQuickFixArray;
        void thisCollection$iv;
        void $receiver$iv;
        DomElementAnnotationHolder domElementAnnotationHolder;
        DomElement domElement;
        Object fixes2;
        Object version;
        Object plugin;
        MavenDomPlugin it;
        Object element$iv$iv;
        Iterable $receiver$iv$iv;
        String pluginVersion;
        Iterator it2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        if (domFileElement == null || holder == null) {
            return;
        }
        XmlFile file2 = domFileElement.getFile();
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        Module module2 = module;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(module2);
        if (mavenProject == null) {
            return;
        }
        MavenProject project = mavenProject;
        Iterable iterable = $receiver$iv2 = (Iterable)project.findDependencies(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            MavenArtifact mavenArtifact = (MavenArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it2.getVersion();
            collection.add(string);
        }
        List stdlibVersion = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        MavenPlugin mavenPlugin = project.findPlugin(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinMavenConfigurator.Companion.getMAVEN_PLUGIN_ID());
        String string = pluginVersion = mavenPlugin != null ? mavenPlugin.getVersion() : null;
        if (pluginVersion == null || stdlibVersion.isEmpty() || Intrinsics.areEqual((Object)((String)CollectionsKt.singleOrNull((List)stdlibVersion)), (Object)pluginVersion)) {
            return;
        }
        XmlFile xmlFile = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlFile, (String)"file");
        PomFile pomFile = PomFile.Companion.forFileOrNull(xmlFile);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        Iterable $receiver$iv3 = pomFile2.findKotlinPlugins();
        Iterator iterator2 = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList();
        it2 = $receiver$iv$iv.iterator();
        while (it2.hasNext()) {
            element$iv$iv = it2.next();
            it = (MavenDomPlugin)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getVersion().getStringValue(), (Object)((String)CollectionsKt.singleOrNull((List)stdlibVersion))) ^ true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv3 = (List)destination$iv$iv2;
        for (Object element$iv : $receiver$iv3) {
            List<SetVersionQuickFix> list2;
            block22: {
                block21: {
                    plugin = (MavenDomPlugin)element$iv;
                    list2 = plugin.getVersion().getStringValue();
                    if (list2 == null) break block21;
                    version = element$iv$iv = list2;
                    MavenProject mavenProject2 = project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mavenProject2, (String)"project");
                    GenericDomValue genericDomValue = plugin.getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)genericDomValue, (String)"plugin.version");
                    list2 = this.createFixes(mavenProject2, genericDomValue, CollectionsKt.plus((Collection)stdlibVersion, version));
                    if (list2 != null) break block22;
                }
                list2 = CollectionsKt.emptyList();
            }
            fixes2 = list2;
            element$iv$iv = (Collection)fixes2;
            String $i$f$filterTo = "Plugin version (" + plugin.getVersion() + ") is not the same as library version (" + CollectionsKt.joinToString$default((Iterable)stdlibVersion, (CharSequence)",", (CharSequence)"", (CharSequence)"", (int)0, null, null, (int)56, null) + ')';
            HighlightSeverity $i$f$filter = HighlightSeverity.WARNING;
            domElement = (DomElement)plugin.getVersion();
            domElementAnnotationHolder = holder;
            if ($receiver$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            if (thisCollection$iv.toArray(new SetVersionQuickFix[thisCollection$iv.size()]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            LocalQuickFix[] localQuickFixArray = setVersionQuickFixArray;
            domElementAnnotationHolder.createProblem(domElement, $i$f$filter, $i$f$filterTo, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
        $receiver$iv3 = PomFile.findDependencies$default(pomFile2, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID(), null), null, 2, null);
        $receiver$iv$iv = $receiver$iv3;
        destination$iv$iv2 = new ArrayList();
        plugin = $receiver$iv$iv.iterator();
        while (plugin.hasNext()) {
            element$iv$iv = plugin.next();
            it = (MavenDomDependency)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getVersion().getStringValue(), (Object)pluginVersion) ^ true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv3 = (List)destination$iv$iv2;
        for (Object element$iv : $receiver$iv3) {
            List<SetVersionQuickFix> list3;
            MavenDomDependency dependency;
            block24: {
                block23: {
                    dependency = (MavenDomDependency)element$iv;
                    list3 = dependency.getVersion().getStringValue();
                    if (list3 == null) break block23;
                    version = element$iv$iv = list3;
                    MavenProject mavenProject3 = project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mavenProject3, (String)"project");
                    GenericDomValue genericDomValue = dependency.getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)genericDomValue, (String)"dependency.version");
                    list3 = this.createFixes(mavenProject3, genericDomValue, CollectionsKt.listOf((Object[])new String[]{version, pluginVersion}));
                    if (list3 != null) break block24;
                }
                list3 = CollectionsKt.emptyList();
            }
            fixes2 = list3;
            element$iv$iv = (Collection)fixes2;
            String string2 = "Plugin version (" + pluginVersion + ") is not the same as library version (" + dependency.getVersion() + ')';
            HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
            domElement = (DomElement)dependency.getVersion();
            domElementAnnotationHolder = holder;
            if ($receiver$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            if (thisCollection$iv.toArray(new SetVersionQuickFix[thisCollection$iv.size()]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            LocalQuickFix[] localQuickFixArray = setVersionQuickFixArray;
            domElementAnnotationHolder.createProblem(domElement, highlightSeverity, string2, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
    }

    private final List<SetVersionQuickFix> createFixes(MavenProject project, GenericDomValue<?> versionElement, List<String> versions) {
        Object object;
        Collection collection;
        Object it;
        Iterable $receiver$iv$iv;
        String bestVersion;
        Object maxElem$iv;
        Object v0;
        Iterable $receiver$iv = versions;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            String p1 = (String)maxElem$iv;
            Comparable maxValue$iv = (Comparable)new MavenVersionComparable(p1);
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                String p12 = (String)e$iv;
                Comparable v$iv = (Comparable)new MavenVersionComparable(p12);
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v0 = maxElem$iv;
        }
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)(bestVersion = (String)v0), (Object)versionElement.getStringValue())) {
            return CollectionsKt.emptyList();
        }
        Iterable $receiver$iv2 = project.getProperties().entrySet();
        maxElem$iv = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            if (!Intrinsics.areEqual(it.getValue(), (Object)bestVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            object = "${" + it.getKey() + '}';
            collection.add(object);
        }
        List properties2 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv2 = (Iterable)properties2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            object = new SetVersionQuickFix(versionElement, (String)it, bestVersion);
            collection.add(object);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)new SetVersionQuickFix(versionElement, bestVersion, null));
    }

    public DifferentMavenStdlibVersionInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection$SetVersionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "versionElement", "Lcom/intellij/util/xml/GenericDomValue;", "newVersion", "", "versionResolved", "(Lcom/intellij/util/xml/GenericDomValue;Ljava/lang/String;Ljava/lang/String;)V", "getNewVersion", "()Ljava/lang/String;", "getVersionElement", "()Lcom/intellij/util/xml/GenericDomValue;", "getVersionResolved", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class SetVersionQuickFix
    implements LocalQuickFix {
        @NotNull
        private final GenericDomValue<?> versionElement;
        @NotNull
        private final String newVersion;
        @Nullable
        private final String versionResolved;

        @NotNull
        public String getName() {
            return this.versionResolved == null ? "Change version to " + this.newVersion : "Change version to " + this.newVersion + " (" + this.versionResolved + ')';
        }

        @NotNull
        public String getFamilyName() {
            return "Change version";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.versionElement.setValue((Object)this.newVersion);
        }

        @NotNull
        public final GenericDomValue<?> getVersionElement() {
            return this.versionElement;
        }

        @NotNull
        public final String getNewVersion() {
            return this.newVersion;
        }

        @Nullable
        public final String getVersionResolved() {
            return this.versionResolved;
        }

        public SetVersionQuickFix(@NotNull GenericDomValue<?> versionElement, @NotNull String newVersion, @Nullable String versionResolved) {
            Intrinsics.checkParameterIsNotNull(versionElement, (String)"versionElement");
            Intrinsics.checkParameterIsNotNull((Object)newVersion, (String)"newVersion");
            this.versionElement = versionElement;
            this.newVersion = newVersion;
            this.versionResolved = versionResolved;
        }
    }
}

