/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.spring.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.highlighting.SpringJavaAutowiringInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightField;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspectionKt;
import org.jetbrains.kotlin.idea.spring.inspections.SpringKotlinAutowiringInspection;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/spring/inspections/SpringKotlinAutowiringInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "javaInspection", "Lcom/intellij/spring/model/highlighting/SpringJavaAutowiringInspection;", "getJavaInspection", "()Lcom/intellij/spring/model/highlighting/SpringJavaAutowiringInspection;", "javaInspection$delegate", "Lkotlin/Lazy;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "AddQualifierFix", "kotlin-ultimate"})
public final class SpringKotlinAutowiringInspection
extends AbstractKotlinInspection {
    private final Lazy javaInspection$delegate = LazyKt.lazy((Function0)javaInspection.2.INSTANCE);
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final SpringJavaAutowiringInspection getJavaInspection() {
        Lazy lazy = this.javaInspection$delegate;
        SpringKotlinAutowiringInspection springKotlinAutowiringInspection = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (SpringJavaAutowiringInspection)lazy.getValue();
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder, isOnTheFly){
            final /* synthetic */ SpringKotlinAutowiringInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            private final void checkAutowiredMethod(PsiMethod psiMethod2, ProblemsHolder holder, CommonSpringModel springModel, boolean required) {
                PsiAnnotation resourceAnnotation = SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)((PsiModifierListOwner)psiMethod2));
                if (resourceAnnotation != null) {
                    PsiType psiType = PropertyUtil.getPropertyType((PsiMember)((PsiMember)psiMethod2));
                    if (psiType == null) {
                        return;
                    }
                    PsiType propertyType = psiType;
                    SpringJavaAutowiringInspection.checkAutowiredPsiMember((PsiModifierListOwner)((PsiModifierListOwner)psiMethod2), (PsiType)propertyType, (ProblemsHolder)holder, (CommonSpringModel)springModel, (boolean)required);
                } else if (psiMethod2.getParameterList().getParametersCount() == 0 && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)((PsiModifierListOwner)psiMethod2))) {
                    PsiIdentifier psiIdentifier = psiMethod2.getNameIdentifier();
                    if (psiIdentifier == null) {
                        return;
                    }
                    PsiIdentifier nameIdentifier = psiIdentifier;
                    String message2 = SpringBundle.message((String)"bean.autowiring.by.type.no.parameter.for.autowired.method", (Object[])new Object[]{psiMethod2.isConstructor() ? "constructor" : "method"});
                    holder.registerProblem((PsiElement)nameIdentifier, message2, new LocalQuickFix[0]);
                } else {
                    PsiParameter[] psiParameterArray = psiMethod2.getParameterList().getParameters();
                    for (int i = 0; i < psiParameterArray.length; ++i) {
                        PsiParameter parameter = psiParameterArray[i];
                        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)parameter), (String)"org.springframework.beans.factory.annotation.Value", (boolean)true)) continue;
                        SpringJavaAutowiringInspection.checkAutowiredPsiMember((PsiModifierListOwner)((PsiModifierListOwner)parameter), (PsiType)parameter.getType(), (ProblemsHolder)holder, (CommonSpringModel)springModel, (boolean)required);
                    }
                }
            }

            private final void registerAdjustedProblems(@NotNull ProblemDescriptor[] $receiver) {
                AbstractKotlinInspectionKt.registerWithElementsUnwrapped($receiver, this.$holder, this.$isOnTheFly, (Function2<? super LocalQuickFix, ? super PsiElement, ? extends LocalQuickFix>)((Function2)buildVisitor.registerAdjustedProblems.1.INSTANCE));
            }

            private final <T extends PsiMember> void processLightMember(@NotNull T $receiver, Function4<? super T, ? super ProblemsHolder, ? super CommonSpringModel, ? super Boolean, Unit> action2) {
                CommonSpringModel commonSpringModel = SpringAutowireUtil.getProcessingSpringModel((PsiClass)$receiver.getContainingClass());
                if (commonSpringModel == null) {
                    return;
                }
                CommonSpringModel model = commonSpringModel;
                boolean required = SpringAutowireUtil.isRequired((PsiModifierListOwner)((PsiModifierListOwner)$receiver));
                ProblemsHolder tmpHolder = new ProblemsHolder(this.$holder.getManager(), $receiver.getContainingFile(), this.$isOnTheFly);
                CommonSpringModel commonSpringModel2 = model;
                Intrinsics.checkExpressionValueIsNotNull((Object)commonSpringModel2, (String)"model");
                action2.invoke($receiver, (Object)tmpHolder, (Object)commonSpringModel2, (Object)required);
                this.registerAdjustedProblems(tmpHolder.getResultsArray());
            }

            private final void processLightMethod(@NotNull PsiMethod $receiver) {
                if (!SpringAutowireUtil.isInjectionPoint((PsiMethod)$receiver)) {
                    return;
                }
                this.processLightMember((PsiMember)$receiver, (Function4)new Function4<PsiMethod, ProblemsHolder, CommonSpringModel, Boolean, Unit>(this){
                    final /* synthetic */ buildVisitor.1 this$0;

                    public final void invoke(@NotNull PsiMethod $receiver, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, boolean required) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
                        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                        buildVisitor.1.access$checkAutowiredMethod(this.this$0, $receiver, holder, model, required);
                    }
                    {
                        this.this$0 = var1_1;
                        super(4);
                    }
                });
            }

            private final void processLightField(@NotNull PsiField $receiver) {
                if (!SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)((PsiModifierListOwner)$receiver))) {
                    return;
                }
                this.processLightMember((PsiMember)$receiver, buildVisitor.processLightField.1.INSTANCE);
            }

            private final void processLightClass(@NotNull PsiClass $receiver) {
                block0: {
                    ProblemDescriptor[] problemDescriptorArray = SpringKotlinAutowiringInspection.access$getJavaInspection$p(this.this$0).checkClass($receiver, this.$holder.getManager(), this.$isOnTheFly);
                    if (problemDescriptorArray == null) break block0;
                    this.registerAdjustedProblems(problemDescriptorArray);
                }
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                    PsiMethod psiMethod2 = (PsiMethod)CollectionsKt.firstOrNull(LightClassUtilsKt.toLightMethods(function2));
                    if (psiMethod2 == null) break block0;
                    this.processLightMethod(psiMethod2);
                }
            }

            public void visitProperty(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                for (PsiNamedElement lightElement : LightClassUtilsKt.toLightElements(property2)) {
                    PsiNamedElement psiNamedElement = lightElement;
                    if (psiNamedElement instanceof KtLightMethod) {
                        this.processLightMethod((PsiMethod)lightElement);
                        continue;
                    }
                    if (!(psiNamedElement instanceof KtLightField)) continue;
                    this.processLightField((PsiField)lightElement);
                }
            }

            public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                    KtLightClass ktLightClass = LightClassUtilsKt.toLightClass(classOrObject);
                    if (ktLightClass == null) break block0;
                    this.processLightClass(ktLightClass);
                }
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
                this.$isOnTheFly = $captured_local_variable$2;
            }

            public static final /* synthetic */ void access$checkAutowiredMethod(buildVisitor.1 $this, @NotNull PsiMethod psiMethod2, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, boolean required) {
                $this.checkAutowiredMethod(psiMethod2, holder, springModel, required);
            }
        };
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SpringKotlinAutowiringInspection.class), "javaInspection", "getJavaInspection()Lcom/intellij/spring/model/highlighting/SpringJavaAutowiringInspection;"))};
    }

    @NotNull
    public static final /* synthetic */ SpringJavaAutowiringInspection access$getJavaInspection$p(SpringKotlinAutowiringInspection $this) {
        return $this.getJavaInspection();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\b0\bH\u0016J\u0010\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\b0\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/spring/inspections/SpringKotlinAutowiringInspection$AddQualifierFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "modifierListOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "beanPointers", "", "Lcom/intellij/spring/model/SpringBeanPointer;", "annotationFqName", "", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Ljava/util/Collection;Ljava/lang/String;)V", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "createQualifierNameTemplate", "Lcom/intellij/codeInsight/template/Template;", "expression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "getFamilyName", "kotlin.jvm.PlatformType", "getName", "getQualifierNamesSuggestNamesExpression", "Lcom/intellij/codeInsight/template/Expression;", "kotlin-ultimate"})
    public static final class AddQualifierFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<KtModifierListOwner> elementPointer;
        private final Collection<SpringBeanPointer<?>> beanPointers;
        private final String annotationFqName;

        public String getName() {
            return SpringBundle.message((String)"SpringAutowiringInspection.add.qualifier.fix", (Object[])new Object[0]);
        }

        public String getFamilyName() {
            return this.getName();
        }

        private final Expression getQualifierNamesSuggestNamesExpression(KtStringTemplateExpression expression2) {
            return new Expression(this, expression2){
                final /* synthetic */ AddQualifierFix this$0;
                final /* synthetic */ KtStringTemplateExpression $expression;

                @Nullable
                public Result calculateResult(@NotNull ExpressionContext context) {
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                    return (Result)new TextResult(KtPsiUtilKt.getPlainContent(this.$expression));
                }

                @Nullable
                public Result calculateQuickResult(@NotNull ExpressionContext context) {
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    return this.calculateResult(context);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public LookupElement[] calculateLookupItems(@NotNull ExpressionContext context) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                    Iterable iterable = $receiver$iv = (Iterable)AddQualifierFix.access$getBeanPointers$p(this.this$0);
                    Comparator comparator = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            SpringBeanPointer it = (SpringBeanPointer)a;
                            String string = it.getName();
                            if (string == null) {
                                string = "";
                            }
                            it = (SpringBeanPointer)b;
                            Comparable comparable = (Comparable)((Object)string);
                            String string2 = it.getName();
                            if (string2 == null) {
                                string2 = "";
                            }
                            String string3 = string2;
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string3)));
                        }
                    };
                    $receiver$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
                    iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    void $receiver$iv$iv$iv = $receiver$iv$iv;
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        LookupElement lookupElement2;
                        T element$iv$iv = element$iv$iv$iv;
                        SpringBeanPointer it = (SpringBeanPointer)element$iv$iv;
                        if (SpringConverterUtil.createCompletionVariant((SpringBeanPointer)it) == null) continue;
                        LookupElement it$iv$iv = lookupElement2;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    Iterable thisCollection$iv = $receiver$iv;
                    LookupElement[] lookupElementArray = thisCollection$iv.toArray(new LookupElement[thisCollection$iv.size()]);
                    if (lookupElementArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    return lookupElementArray;
                }
                {
                    this.this$0 = $outer;
                    this.$expression = $captured_local_variable$1;
                }
            };
        }

        private final Template createQualifierNameTemplate(KtStringTemplateExpression expression2) {
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)expression2.getContainingFile());
            builder.replaceRange(KtPsiUtilKt.getContentRange(expression2).shiftRight(PsiUtilsKt.getStartOffset((PsiElement)expression2)), this.getQualifierNamesSuggestNamesExpression(expression2));
            Template template2 = builder.buildInlineTemplate();
            Intrinsics.checkExpressionValueIsNotNull((Object)template2, (String)"builder.buildInlineTemplate()");
            return template2;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            KtAnnotationEntry addedEntry;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.elementPointer.getElement();
            if (ktModifierListOwner == null) {
                return;
            }
            KtModifierListOwner modifierListOwner = ktModifierListOwner;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)modifierListOwner)) {
                return;
            }
            if (this.beanPointers.isEmpty()) {
                return;
            }
            String string = ((SpringBeanPointer)CollectionsKt.first((Iterable)this.beanPointers)).getName();
            String $receiver = string;
            CharSequence charSequence = $receiver;
            String defaultBeanName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "Unknown" : $receiver;
            KtAnnotationEntry entry = new KtPsiFactory(project, false, 2, null).createAnnotationEntry('@' + this.annotationFqName + "(\"" + defaultBeanName + "\")");
            KtAnnotationEntry ktAnnotationEntry = addedEntry = modifierListOwner.addAnnotationEntry(entry);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"addedEntry");
            ShortenReferences.process$default(ShortenReferences.DEFAULT, ktAnnotationEntry, null, 2, null);
            KtExpression ktExpression = ((ValueArgument)CollectionsKt.first(addedEntry.getValueArguments())).getArgumentExpression();
            if (!(ktExpression instanceof KtStringTemplateExpression)) {
                ktExpression = null;
            }
            KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
            if (ktStringTemplateExpression == null) {
                return;
            }
            KtStringTemplateExpression stringTemplate = ktStringTemplateExpression;
            VirtualFile virtualFile2 = modifierListOwner.getContainingFile().getVirtualFile();
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile virtualFile3 = virtualFile2;
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile3, 0), false);
            if (editor == null) {
                Intrinsics.throwNpe();
            }
            Editor editor2 = editor;
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
            TemplateManager.getInstance((Project)project).startTemplate(editor2, this.createQualifierNameTemplate(stringTemplate));
        }

        public AddQualifierFix(@NotNull KtModifierListOwner modifierListOwner, @NotNull Collection<? extends SpringBeanPointer<?>> beanPointers, @NotNull String annotationFqName) {
            Intrinsics.checkParameterIsNotNull((Object)modifierListOwner, (String)"modifierListOwner");
            Intrinsics.checkParameterIsNotNull(beanPointers, (String)"beanPointers");
            Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
            this.beanPointers = beanPointers;
            this.annotationFqName = annotationFqName;
            this.elementPointer = PsiUtilsKt.createSmartPointer((PsiElement)modifierListOwner);
        }

        @NotNull
        public static final /* synthetic */ Collection access$getBeanPointers$p(AddQualifierFix $this) {
            return $this.beanPointers;
        }
    }
}

