/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

public class JsConfig {
    public static final List<String> JS_STDLIB = Collections.singletonList(org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForDistDirectory().getJsStdLibJarPath().getAbsolutePath());
    public static final List<String> JS_KOTLIN_TEST = Collections.singletonList(org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForDistDirectory().getJsKotlinTestJarPath().getAbsolutePath());
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";
    private final Project project;
    private final CompilerConfiguration configuration;
    private final LockBasedStorageManager storageManager;
    private final List<KotlinJavascriptMetadata> metadata;
    private final List<KotlinJavascriptMetadata> friends;
    @Nullable
    private List<JsModuleDescriptor<ModuleDescriptorImpl>> moduleDescriptors;
    @Nullable
    private List<JsModuleDescriptor<ModuleDescriptorImpl>> friendModuleDescriptors;
    private boolean initialized;
    private final IdentityHashMap<KotlinJavascriptMetadata, JsModuleDescriptor<ModuleDescriptorImpl>> factoryMap;

    public JsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        if (configuration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        this.storageManager = new LockBasedStorageManager();
        this.metadata = new SmartList();
        this.friends = new SmartList();
        this.moduleDescriptors = null;
        this.friendModuleDescriptors = null;
        this.initialized = false;
        this.factoryMap = new IdentityHashMap();
        this.project = project;
        this.configuration = configuration2;
    }

    @NotNull
    public CompilerConfiguration getConfiguration() {
        CompilerConfiguration compilerConfiguration = this.configuration;
        if (compilerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getConfiguration"));
        }
        return compilerConfiguration;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getModuleId() {
        String string = this.configuration.getNotNull(CommonConfigurationKeys.MODULE_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleId"));
        }
        return string;
    }

    @NotNull
    public ModuleKind getModuleKind() {
        ModuleKind moduleKind = this.configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        if (moduleKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleKind"));
        }
        return moduleKind;
    }

    @NotNull
    public List<String> getLibraries() {
        List<String> list2 = this.getConfiguration().getList(JSConfigurationKeys.LIBRARIES);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getLibraries"));
        }
        return list2;
    }

    @NotNull
    public String getSourceMapPrefix() {
        String string = this.configuration.get(JSConfigurationKeys.SOURCE_MAP_PREFIX, "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getSourceMapPrefix"));
        }
        return string;
    }

    @NotNull
    public List<String> getSourceMapRoots() {
        List<String> list2 = this.configuration.get(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, Collections.singletonList("."));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getSourceMapRoots"));
        }
        return list2;
    }

    @NotNull
    public SourceMapSourceEmbedding getSourceMapContentEmbedding() {
        SourceMapSourceEmbedding sourceMapSourceEmbedding = this.configuration.get(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, SourceMapSourceEmbedding.INLINING);
        if (sourceMapSourceEmbedding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getSourceMapContentEmbedding"));
        }
        return sourceMapSourceEmbedding;
    }

    @NotNull
    public List<String> getFriends() {
        if (this.getConfiguration().getBoolean(JSConfigurationKeys.FRIEND_PATHS_DISABLED)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getFriends"));
            }
            return list2;
        }
        List<String> list3 = this.getConfiguration().getList(JSConfigurationKeys.FRIEND_PATHS);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getFriends"));
        }
        return list3;
    }

    public boolean checkLibFilesAndReportErrors(@NotNull Reporter report2) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/JsConfig", "checkLibFilesAndReportErrors"));
        }
        return this.checkLibFilesAndReportErrors(report2, null);
    }

    private boolean checkLibFilesAndReportErrors(@NotNull Reporter report2, @Nullable Function2<VirtualFile, String, Unit> action2) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/JsConfig", "checkLibFilesAndReportErrors"));
        }
        return this.checkLibFilesAndReportErrors(this.getLibraries(), report2, action2);
    }

    private boolean checkLibFilesAndReportErrors(@NotNull Collection<String> libraries, @NotNull Reporter report2, @Nullable Function2<VirtualFile, String, Unit> action2) {
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "org/jetbrains/kotlin/js/config/JsConfig", "checkLibFilesAndReportErrors"));
        }
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/JsConfig", "checkLibFilesAndReportErrors"));
        }
        if (libraries.isEmpty()) {
            return false;
        }
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        VirtualFileSystem jarFileSystem = VirtualFileManager.getInstance().getFileSystem("jar");
        HashSet<String> modules = new HashSet<String>();
        boolean skipMetadataVersionCheck = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration).getFlag(AnalysisFlag.getSkipMetadataVersionCheck());
        for (String path : libraries) {
            File filePath = new File(path);
            if (!filePath.exists()) {
                report2.error("Path '" + path + "' does not exist");
                return true;
            }
            VirtualFile file2 = path.endsWith(".jar") || path.endsWith(".zip") ? jarFileSystem.findFileByPath(path + "!/") : fileSystem.findFileByPath(path);
            if (file2 == null) {
                report2.error("File '" + path + "' does not exist or could not be read");
                return true;
            }
            List<KotlinJavascriptMetadata> metadataList = KotlinJavascriptMetadataUtils.loadMetadata(filePath);
            if (metadataList.isEmpty()) {
                report2.warning("'" + path + "' is not a valid Kotlin Javascript library");
                continue;
            }
            for (KotlinJavascriptMetadata metadata : metadataList) {
                if (!metadata.getVersion().isCompatible() && !skipMetadataVersionCheck) {
                    report2.error("File '" + path + "' was compiled with an incompatible version of Kotlin. The binary version of its metadata is " + metadata.getVersion() + ", expected version is " + JsMetadataVersion.INSTANCE);
                    return true;
                }
                if (modules.add(metadata.getModuleName())) continue;
                report2.warning("Module \"" + metadata.getModuleName() + "\" is defined in more than one file");
            }
            if (action2 == null) continue;
            action2.invoke((Object)file2, (Object)path);
        }
        return false;
    }

    @NotNull
    public List<JsModuleDescriptor<ModuleDescriptorImpl>> getModuleDescriptors() {
        this.init();
        if (this.moduleDescriptors != null) {
            List<JsModuleDescriptor<ModuleDescriptorImpl>> list2 = this.moduleDescriptors;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleDescriptors"));
            }
            return list2;
        }
        this.moduleDescriptors = new SmartList();
        ArrayList<ModuleDescriptorImpl> kotlinModuleDescriptors = new ArrayList<ModuleDescriptorImpl>();
        for (KotlinJavascriptMetadata kotlinJavascriptMetadata : this.metadata) {
            JsModuleDescriptor<ModuleDescriptorImpl> descriptor2 = this.createModuleDescriptor(kotlinJavascriptMetadata);
            this.moduleDescriptors.add(descriptor2);
            kotlinModuleDescriptors.add(descriptor2.getData());
        }
        for (JsModuleDescriptor jsModuleDescriptor : this.moduleDescriptors) {
            JsConfig.setDependencies((ModuleDescriptorImpl)jsModuleDescriptor.getData(), kotlinModuleDescriptors);
        }
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list3 = this.moduleDescriptors = Collections.unmodifiableList(this.moduleDescriptors);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleDescriptors"));
        }
        return list3;
    }

    @NotNull
    public List<JsModuleDescriptor<ModuleDescriptorImpl>> getFriendModuleDescriptors() {
        this.init();
        if (this.friendModuleDescriptors != null) {
            List<JsModuleDescriptor<ModuleDescriptorImpl>> list2 = this.friendModuleDescriptors;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getFriendModuleDescriptors"));
            }
            return list2;
        }
        this.friendModuleDescriptors = new SmartList();
        for (KotlinJavascriptMetadata metadataEntry : this.friends) {
            JsModuleDescriptor<ModuleDescriptorImpl> descriptor2 = this.createModuleDescriptor(metadataEntry);
            this.friendModuleDescriptors.add(descriptor2);
        }
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list3 = this.friendModuleDescriptors = Collections.unmodifiableList(this.friendModuleDescriptors);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getFriendModuleDescriptors"));
        }
        return list3;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        if (!this.getLibraries().isEmpty()) {
            Reporter reporter = new Reporter(){

                @Override
                public void error(@NotNull String message2) {
                    if (message2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/js/config/JsConfig$1", "error"));
                    }
                    throw new IllegalStateException(message2);
                }
            };
            boolean hasErrors = this.checkLibFilesAndReportErrors(this.getFriends(), reporter, (Function2<VirtualFile, String, Unit>)((Function2)(file2, path) -> {
                List<KotlinJavascriptMetadata> metaList = JsConfig.loadMetadata(file2, "friendPath");
                this.metadata.addAll(metaList);
                this.friends.addAll(metaList);
                return Unit.INSTANCE;
            }));
            assert (!(hasErrors |= this.checkLibFilesAndReportErrors(CollectionsKt.subtract(this.getLibraries(), this.getFriends()), reporter, (Function2<VirtualFile, String, Unit>)((Function2)(file2, path) -> {
                this.metadata.addAll(JsConfig.loadMetadata(file2, "libraryPath"));
                return Unit.INSTANCE;
            })))) : "hasErrors should be false";
        }
        this.initialized = true;
    }

    @NotNull
    private static List<KotlinJavascriptMetadata> loadMetadata(@NotNull VirtualFile file2, @NotNull String name2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/js/config/JsConfig", "loadMetadata"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/config/JsConfig", "loadMetadata"));
        }
        String libraryPath = PathUtil.getLocalPath((VirtualFile)file2);
        assert (libraryPath != null) : name2 + " for " + file2 + " should not be null";
        List<KotlinJavascriptMetadata> list2 = KotlinJavascriptMetadataUtils.loadMetadata(libraryPath);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "loadMetadata"));
        }
        return list2;
    }

    private JsModuleDescriptor<ModuleDescriptorImpl> createModuleDescriptor(KotlinJavascriptMetadata metadata) {
        return this.factoryMap.computeIfAbsent(metadata, m -> {
            LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration);
            assert (m.getVersion().isCompatible() || languageVersionSettings.getFlag(AnalysisFlag.getSkipMetadataVersionCheck()).booleanValue()) : "Expected JS metadata version " + JsMetadataVersion.INSTANCE + ", but actual metadata version is " + m.getVersion();
            ModuleDescriptorImpl moduleDescriptor = new ModuleDescriptorImpl(Name.special("<" + m.getModuleName() + ">"), this.storageManager, JsPlatform.INSTANCE.getBuiltIns());
            JsModuleDescriptor<PackageFragmentProvider> rawDescriptor = KotlinJavascriptSerializationUtil.readModule(m.getBody(), this.storageManager, moduleDescriptor, new CompilerDeserializationConfiguration(languageVersionSettings));
            PackageFragmentProvider provider2 = rawDescriptor.getData();
            moduleDescriptor.initialize(provider2 != null ? provider2 : PackageFragmentProvider.Empty.INSTANCE);
            return rawDescriptor.copy(moduleDescriptor);
        });
    }

    private static void setDependencies(ModuleDescriptorImpl module, List<ModuleDescriptorImpl> modules) {
        module.setDependencies(CollectionsKt.plus(modules, (Object)JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule()));
    }

    public static abstract class Reporter {
        public void error(@NotNull String message2) {
            if (message2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/js/config/JsConfig$Reporter", "error"));
            }
        }

        public void warning(@NotNull String message2) {
            if (message2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/js/config/JsConfig$Reporter", "warning"));
            }
        }
    }
}

